/***************************************************************************
 *   Copyright (C) 2005 by Oleksandr Shneyder                              *
 *   oleksandr.shneyder@treuchtlingen.de                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _AKTENPLAN_H_
#define _AKTENPLAN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QMainWindow>
// #include <kio/jobclasses.h>


/**
 * @short Application Main Window
 * @author Oleksandr Shneyder <oleksandr.shneyder@treuchtlingen.de>
 * @version 0.3.0
 */
class QAction;
class QLineEdit;
class QPushButton;
class AListView;
class QTreeWidgetItem;
class QLabel;
class QSettings;
class QUrl;
class QToolButton;
class QTreeWidget;
class ATabView;

class aKtenplan : public QMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    aKtenplan();

    /**
     * Default Destructor
     */
    virtual ~aKtenplan();
    void initTable();
    void closeList();
private:
    ATabView* table;
    AListView* list;
    bool tableView;
    QString fileName;
    QString rootURL;
    bool searchChanged;
    int numOfRaws;
    QTreeWidgetItem*  lastItem;
    int lastIndex;
    QLineEdit *lineEdit;
    QAction* pSwitch;
    QAction* copy;
    QAction* copyAll;
    QAction* openFolder;
    QSettings* mConfig;
    QToolButton* findButton;
    QLabel* mStatus;
    QString searchVal;
    QString currentVal;
    QString currentPath;
    QString searchText;
private:
    void initList();
    void saveFname();
    void listOpen(const QString& text);
    void fileNameDropped(const QString& fn);
    void dir(QString path);
    void process(const QStringList& dirList);
    void launchKonqueror(QString path);

    void initDir(QTreeWidgetItem* it, QString base, QString path);
    void createIndexFile(QString path, bool shelf);

public slots:
    bool slotGetFname();
    void slotOpenList();
//    void slotEntries(KIO::Job *job, const KIO::UDSEntryList &list);
//    void slotResult(KIO::Job*   job);
private slots:
    void slotAbout();
    void slotAboutQt();
    void slotSwitchView();
    void slotCopy();
    void slotCopyAll();
    void slotSearchText(const QString& );
    void slotFind();
    void slotFOpen();
    void slotOpenFolder();
    void slotCreateFolder();
    void slotSelectRoot();
protected:
    void contextMenuEvent(QContextMenuEvent *event);
//     void dragEnterEvent (QDragEnterEvent *qdragenterevent);
};
#endif // _AKTENPLAN_H_
