/***************************************************************************
 *   Copyright (C) 2005 by Oleksandr Shneyder                              *
 *   oleksandr.shneyder@treuchtlingen.de                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "alistview.h"
#include <QMouseEvent>
#include <QDrag>
#include <QMimeData>
#include <QApplication>

AListView::AListView(QWidget *parent)
: QTreeWidget(parent)
{}


AListView::~AListView()
{}



QString AListView::allSelectedText()
{
    QString txt;
    QTreeWidgetItemIterator it(this);
    while ( *it)
    {
        if((*it)->isSelected())
        {
            txt+=(*it)->text(0)+"\t"+(*it)->text(1)+"\n";
        }
        ++it;
    }
    return txt;
}

void AListView::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton)
        dragStartPosition = event->pos();
    QTreeWidget::mousePressEvent(event);
}


void AListView::mouseMoveEvent(QMouseEvent* event)
{
    if (!(event->buttons() & Qt::LeftButton))
    {
//         QTreeWidget::mouseMoveEvent(event);
        return;
    }
    if ((event->pos() - dragStartPosition).manhattanLength()
        < QApplication::startDragDistance())
    {
//         QTreeWidget::mouseMoveEvent(event);
        return;
    }

    QDrag *drag = new QDrag(this);
    QMimeData *mimeData = new QMimeData;

    mimeData->setText(allSelectedText());
    drag->setMimeData(mimeData);
    drag->setPixmap(QPixmap(":/icons/hi128-app-aktenplan.png"));

    drag->exec(Qt::CopyAction | Qt::MoveAction);
}

