/***************************************************************************
 *   Copyright (C) 2005 by Oleksandr Shneyder                              *
 *   oleksandr.shneyder@treuchtlingen.de                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "atabview.h"
#include <QMouseEvent>
#include <QDrag>
#include <QMimeData>
#include <QApplication>

ATabView::ATabView(int r, int c, QWidget *parent)
: QTableWidget(r,c,parent)
{}


ATabView::~ATabView()
{}



QString ATabView::allSelectedText()
{
    QString txt;
    for(int i=0;i<this->rowCount();++i)
    {
        if(item(i,0)->isSelected())
        {
            txt+=verticalHeaderItem(i)->text() +"\t"+item(i,0)->text()+"\n";
        }
    }
    return txt;
}

void ATabView::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton)
        dragStartPosition = event->pos();
    QTableWidget::mousePressEvent(event);
}


void ATabView::mouseMoveEvent(QMouseEvent* event)
{
    if (!(event->buttons() & Qt::LeftButton))
    {
//         QTreeWidget::mouseMoveEvent(event);
        return;
    }
    if ((event->pos() - dragStartPosition).manhattanLength()
        < QApplication::startDragDistance())
    {
//         QTreeWidget::mouseMoveEvent(event);
        return;
    }

    QDrag *drag = new QDrag(this);
    QMimeData *mimeData = new QMimeData;

    mimeData->setText(allSelectedText());
    drag->setMimeData(mimeData);
    drag->setPixmap(QPixmap(":/icons/hi128-app-aktenplan.png"));

    drag->exec(Qt::CopyAction | Qt::MoveAction);
}

