from booksynclib import Bookmark,Update

def update_initial(bookmarks):
	for bookmark in bookmarks:
		if bookmark.is_system and (bookmark.name == "Dokumente" or bookmark.name == "Documents"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.name == "Pictures" or bookmark.name == "Bilder"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.name == "Music" or bookmark.name == "Musik"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.name == "Videos"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.name == "Desktop"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.uri == "remote:/"):
			bookmark.deleteflag = True
		if bookmark.is_system and (bookmark.name == "Downloads"):
			bookmark.id = "tr-downloads"
			bookmark.n = -2000+4
		if bookmark.is_system and (bookmark.name == "Home"):
			bookmark.id = "tr-home"
			bookmark.n = -2000+3
		if bookmark.uri == "trash:/":
			bookmark.id = "tr-trash"
			bookmark.n = -2000+5
	bookmarks.append(Bookmark("Favoriten", "file:///favoriten", "favorites", True, "tr-favorites", n=-2000+0, include_in_gtk = True))
	bookmarks.append(Bookmark("Aktenplan", "file:///aktenplan", "folder-documents", True, "tr-aktenplan", n=-2000+1, include_in_gtk = True))
	bookmarks.append(Bookmark("Austausch", "file:///austausch", "folder-remote", True, "tr-austausch", n=-2000+2, include_in_gtk = True))
	
def update_add_foo(bookmarks):
	pos = 2000
	for bookmark in bookmarks:
		if bookmark.id == "tr-aktenplan":
			pos = bookmark.n
	for bookmark in bookmarks:
		if bookmark.n >= pos:
			bookmark.n += 1
	bookmarks.append(Bookmark("Foo", "file:///foo", "folder-remote", False, "tr-foo", n=pos, include_in_gtk = False))

def update_rename_foo(bookmarks):
	for bookmark in bookmarks:
		if bookmark.id == "tr-foo":
			bookmark.name = bookmark.name+" (Alt und gammlig)"
	
def update_remove_foo(bookmarks):
	for bookmark in bookmarks:
		if bookmark.id == "tr-foo":
			bookmark.deleteflag = True
		
updates = [
	Update("initial", update_initial, "Bookmarks initialisieren", "Standardeinstellungen für die Stadt Treuchtlingen anpassen."),
	#Update("add_foo", update_add_foo, "Foo hinzufügen", "Einen Testbookmark einen Eintrag vor dem Aktenplan einfügen"),
	#Update("rename_foo", update_rename_foo, "Foo umbenennen", "Testbookmark umbenennen"),
	#Update("rm_foo", update_remove_foo, "Foo entfernen", "Testbookmark wieder entfernen"),
]
