# Booksync

Bookmark syncronisation and update tool.

## Tools

### booksyncd

A little bash script that uses `inotifywait` to sync KDE-Plasma bookmarks to Gtk-Bookmarks and applies updates from `/etc/booksync_updates.py` (Which needs to be readable and valid python3). It currently does *not* support folders.

You can run it in the background of you Desktop-envoirenment.

### booksync.py

The python script that can do the exporting to gtk and updating of bookmarks.

By default it will parse the bookmark file and then realize that it has nothing to do.

### Usage:

#### --enable-gtk-export
Enables exporting to the gtk-3 bookmark file

#### --set-gtk-path {path}
Sets the file to export the gtk bookmarks to, and enable gtk exporting.
If not set the path for gtk exporting will default to `~/.config/gtk-3.0/bookmarks`.

#### --apply-updates-from {path}
Adds an update file to apply. {path} must point to a valid python script wich can update bookmarks.
This option may be specified multiple times, updates will be applied in the order the files were loaded.

#### --set-xbel-path {path}
This option will set the path of the xbel file booksync operates on.

### Backups and reconstructing bookmarks

Booksyncd always makes a backup of files it attempts to write to with a `.bak` appended to the filename (Wich will be overwritten when booksync runs again)

Booksync also attempts to write all data it gets from parsing bookmarks files to stdout, so that bookmarks could be reconstructed from log.

### Updates

Update files are python3 files wich contain functions that do the updating and an array called `updates` wich must contain `Update` objects that describe the updates the file provides, it may also be empty if the file currently provides no updates.

Refer to the src/updates.py example.

## Installation

### Dependencies

* python3
* inotify-tools (for inotifywait)
* bash

### Files

#### src/booksync.py
Can be put in a bin folder

#### src/booksyncd
Can also be put in a bin folder, may need some customization.

#### src/updates.py
An example updates file which covers most basic usecases with a real-life example from the city of Treuchtlingen.

#### src/booksynclib.py
Contains the Bookmark and Update classes wich currently only hold data, refer to it when writing updates.

You shoud install it to somewhere where python recognizes it as a loadable module.
