# Minimon

Minimon is a small monitoring system for local, on device monitoring. Based on check results it can trigger hooks and generate reports that are written to the filesystem as JSON.

## Usage


To use Minimon, call `minimon.py` with the configuration files as arguments. They will be overlayed with later ones overriding objcts in earlier ones.

## Configuration

Each configuration file is a json dictionary, with the object name as the key and another dictionary as the value.

Valid object keys are:

`type`
: (string) Which type the configuration object has

`invert_result`
: (bool) Wheter to report the ok status inverted
: Default: `false`

`command`
: (string[]) Array of arguments that represent the command to be executed
: Example: `["echo", "Hello World!"]`

`is_required_by`
: (string[]) Array of names this is required by, this will be merged into the `requires` arrays of the targets

`requires`
: (string[]) Array of names required for this object to "function" (for the exact menaing see the type documentation)

`min_interval`
: (integer) Number of seconds to wait inbetween `check` invocations after every change
: Default: `10`

`max_interval`
: (integer) Number of seconds between `check` invocations to ramp up to if nothing changes

`trigger_edge`
: (string) The edge of the ok-status to trigger a signal on.
: Possible Values are: `both`, `rising`, `falling`, `trigger`
: Default: `both`

`trigger_on_init`
: (bool) Wheter to trigger when transitioning from the initial unknown state to a known state.
: Default: `true`

`report_topic`
: (string) Human readable label for a report topic this object represents

`report_label`
: (string) Human readable label for a report item this object represents

`report_include_if`
: (string) If set the object named by this must have a `true` ok-state for this item to be included in the report
: Default: unconditional include

`report_destination_path`
: (string) The file-path to write the report to
: Default: don't write the report

Valid object types are:
* `check`
* `and`
* `or`
* `trigger`
* `hook`
* `report`

### type: check

Checks are commands that are periodically run in order to test for an OK or ERROR state of some kind.

The check will only be active if all objects it `requires` have an ok-status of `true`.

If the status of a _requirement_ changes the check behaves as if it was triggered, this can be configured using the `trigger_edge` and `trigger_on_init` settings. See documentation for `trigger` type objects for more detail.

**If triggered** and the check is scheduleable is is sceduled as soon as possible and the check interval is reset to the `min_interval`.

**Ok-status output** is the wheter the exit code of the last check command was `0` and the check is active.

### type: and/or

Objects of type `and` and `or` represent the aggregation of their _requirements_.

**Ok-status output** is for `and` wheter there are no unmet requirements and for `or` wheter at least one requirement is met.

**Hint:** using the `invert_result` once can turn them into `nand` and `nor`.

For reports they may carry a `report_topic`.

They don't react to triggers.

### type: trigger

Triggers monitor the ok-status of their _requirements_ and send out a signal to objects that require them if an monitored ok-status changes.

**If triggered** the signal is forwarded as if the trigger itself had generated it.

When a signal is generated depends on the `trigger_edge` and `trigger_on_init` settings.

For the trigger edge:

`rising`
: A signal is generated only when an ok-status changes to `true`

`falling`
: A signal is generated only when an ok-status changes to `false`

`both` (default)
: A signal is generated when an ok-status changes

`trigger`
: The ok-status are ignored, the trigger on reacts to signals from other triggers

**Ok-status output** is always `true` for trigger objects.

### type: hook

Hooks are commands that unlike checks only run when triggered and the _requirements_ are all reporting an ok-status of `true`.

**If triggered** the command is scheduled if _requirements_ are met.

Hooks can only be triggerd by `trigger` objects.

**Ok-status output** is the wheter the exit code of the last check command was `0` and the hook is active.

### type: report

Report objects are an entrypoint to generating reports about the system state. The report is generated by traversing the dependency tree.

Objects with a `report_topic` are converted to containers. Objects with a `report_label` are treted as items, their _requirements_ are not included in the report.

`trigger` objects are never included in reports and their requirements not traversed.

Reports self-trigger on their _requirements_, this is equivalent to the heaviour of checks.

If one of the direct _requirements_ updates this has the same effect as triggering a report.

**If triggered** a new report is generated and written to the file specified using `report_destination_path`.

**Ok-status output** is always `false`, this is a placeholder and may change in the future.

## Concepts

### OK-status

Every object has an ok-status, this is a boolean, that represents OK with `true` and ERROR with `false`.

If it changed an update is scheduled for all objects that are marked as requiring the object the status is attached to.

## Trigger Signals

Trigger signals are generated by `trigger` objects when a status changed. A trigger signal causes the command of an object to be sceduled as soon as possible if the objects requirements are met, this applies to `check` and `hook` objects.

A `trigger` will pass on a trigger signal to all objects that require it.

## `requires` and `is_required_by`

Each object may require one or more other objects to be "functional", or in case of trigger objcts receive triggers.

What functional means exactly is defined by the object type itself.

The `requires` and `required_by` are two ways of expressing a requirement relation between two objects.

If `A` `requires` `B` it has the same effect as `B` `is_required_by` `A`.

These two ways of expressing requirement relations allows a base configuration to offer extension points for a more specialized configuration.

## Report structure

Reports are always written as JSON.

They consist of an array of items.

This array contains objects with the following keys:

`type`
: (string) Which kind of entry this is, either `topic` or `item`

`status`
: (string) The status of the entry, either `WAIT`, `OK` or `ERROR`

`label`
: (string) Human reaable label for the item

`items`
: (object[]) Array of items with the same schema as the report itself. Only present if `tpye` is `topic`

## Unimplemented features

Currently error detection and reporting is not implemented. A misconfiguration may cause anything from an infinite loop to a program crash.
