#!/bin/sh

set -eu

PAM_USER_UID="$(id -u -- "$PAM_USER")"
LOCAL_HOME_PATH="/local/home/$PAM_USER_UID"

umask 0022

# Try to create /local/home if we are root
[ "$UID" != "0" ] || /bin/mkdir -p "/local/home"

umask 0077
/bin/mkdir -p "$LOCAL_HOME_PATH"
/bin/chown "$PAM_USER_UID:$(id -g -- "$PAM_USER")" "$LOCAL_HOME_PATH"

