# foxde-utils package

The foxde-utils are helper scripts for building custom human-machine interaction and andministration.

They mostly are written in bash and make use of [KDialog](https://develop.kde.org/docs/administration/kdialog/).

Because of our X2go approach we mostly run our desktops on Xorg, which means that some things are Xorg dependant and would have to be adjusted to work on wayland.

**Language:** The scripts themselfes are in english, though the user-facing parts (messages, window titles, etc.) are all hardcoded to be in german.

This repository contains the source for the following packages:
* `foxde-qrscan`
* `foxde-type-date`
* `foxde-printer-settings`
* `foxde-auto-monitor-layout`
* `foxde-bind-to-session`
* `foxde-kill-zombies`
* `foxde-exit`
* `foxde-pam-mkhomedir`
* `foxde-startfoxde`
* `foxde-foxclient` (Internal network details, remove before publishing!)
* `foxde-autologin`
* `foxde-autologin-haltfile`
* `foxde-powersafe`
* `foxde-powersafe-disable`
* `foxde-once`
* `foxde-kio-without-http`
* `foxde-cifs-remount`
* `foxde-localhome`
* `foxde-file-utils`

## QRscan

The `foxde-qrscan` package makes use of zbarcam and KDialog to scan QR-codes from the webcam, offering to copy the content or if it is a link to open it with firefox (which will be replaced with xdg-open soon™).

## Type Date

As it says on the tin, types out the current date in ISO format using `xdotool`, useful when bound to a keyboard shortcut. (Make sure the command triggers when releasing the shortcut, otherwise the modifier keys could pose a little problem.

## Printer Settings

Provides `foxde-set-default-printer`, which uses lpstat to obtain a list of printers and the current default, kdialog to let the user choose a new default, set that default and done.

## Monitor Layout

Makes use of `autorandr` to allow the selection of a few automatic laouts and available layouts that have been preinstalled by the administrator (i.e. for conference rooms). If `arandr` is installed it will aso be presented as an availale option.
Available layouts are:
* Gespiegelt (gleiches Bild auf allen Ausgaben) / Mirrored
* Größten Bildschirm auf die kleineren spiegeln / Mirror big screen to small screen (useful for presenting)
* Mehrere Bildschirme nebeneinander / Horizontal autolayout
* Mehrere Bildschirme übereinander / Vertical autolayout
* (Layouts configured by Administrator matching current hardware)
* Manuell Konfigurieren mit arandr / Launch Arandr

## Bind to Session

Use like `foxde-bind-to-session <command>…`. The given command will be launched in the background and receive a SIGTERM within one second of the X-Server shutting down.

This is useful for programs that should quite together with the graphical session but don't need the connection to the Display Server.

## Kill Zombies

A bit of a misnomer, this one can detect processes stuck in infinite loops that eat away CPU-cycles. It is configurable via command line options and supposed to be run as cronjob.

## Exit

`foxde-exit` can exit or suspend a session that is either an X2go session or a local KDE session without having to worry about which one it is.

It can be extended pretty easily with custom commands for other desktops.

## PAM mkhomedir

A package that automatically sets up automatic creation of home directories on first login using PAM.

## Autologin

Package that creates an autologin user (configurable in `/etc/default/foxde-autologin`) and sets it up to automatically log into the specified session using sddm. Useful for building your own thinclient like systems.

If you are planning to use the x2goclient with its powerbutton feature, there is also the `foxde-autologin-haltfile` package which creates the file the x2goclient will touch when the power-button is pressed and hook a script into it that shuts down the computer when it is pressed.

## Powersafe

Provides the `foxde-powersafe` script which provides a convenient way to disable and re-enable DPMS and screensafers on Xorg for always on displays or things like Videoconferencing systems.

There is also the `foxde-powersafe-disable` package which installs an autostarter that disables powersafing features on session start.

## Once

With this script as a wrapper one can enusre that a program is started only once, useful for preventing accidents with legacy applications that cant handle being started multiple times.

## KIO without http

Package that removes the http module from KIO to stop the KDE desktop from trying to access the internet when using the defult openers for http(s) links.

## CIFS remount

Installs a cronjob that tries to re-mount unounted CIFS shares thathave an entry in `/etc/fstab` in case they decide to unmount themselfes.

## Local Home

Hooks into pam and creates secondary Home directories in `/local_home/<uid>` for every logged in user. These are useful to keep the `XDG_CACHE_HOME` local while `/home` is a network mounted and shared filesystem.

## File Utils

Currently only contains `foxde-set-directory-icon` which rewrites the `.directory` file of a given folder to show the given icon.


