#!/bin/sh

set -eu

# Set PATH so we know where the shell will search
PATH=/bin

PAM_USER_UID="$(id -u -- "$PAM_USER")"
LOCAL_HOME_PATH="/local/home/$PAM_USER_UID"

umask 0022

# Try to create /local/home if we are root
[ "$(id -u)" != "0" ] || mkdir -p "/local/home"

umask 0077
[ -d "$LOCAL_HOME_PATH" ] || mkdir -p "$LOCAL_HOME_PATH"
chown "$PAM_USER_UID:$(id -g -- "$PAM_USER")" "$LOCAL_HOME_PATH"
chmod 700 "$LOCAL_HOME_PATH"
