# Fuchs Kiosk

A wrapper for the [interactive-kiosk-browser](https://codeberg.org/stadt_treuchtlingen/interactive-kiosk-browser) that aims to be simple and opinioated.

The main focus is providing a thin layer over standard tools that makes it easier to administrate an interactive kiosk system.

It is based on [runit](https://smarden.org/runit/), [sway](https://swaywm.org) and [squeekboard](https://https://gitlab.gnome.org/World/Phosh/squeekboard).

Features include:
* Supervising processes needed for the kiosk system.
* Keeping track of whetrer the kiosk is currently in use.
* Making sure the kiosk can cleanly reset after it was used.
* Automatically rolling back broken configuration to avoid a "quick" change turning into a timesink.
* A mechanism for pulling most configuration from git enabling central configuration and transparency if desired.
* An onscreen keyboard.

It explicitly excludes any kind of content management.

In case you are searching for something simpler that just puts a webpage on a screen you should have a look at the much simpler [surf-display](https://code.it-zukunft-schule.de/cgit/surf-display/).

## What is in here?

[debian/](debian)
: contains debian packaging

[fuchs-kiosk.desktop](fuchs-kiosk.desktop)
: A file that when placed under `/usr/share/wayland-sessions/` makes the kiosk available as a desktop for display managers. (like lightdm, sddm and tinydm)

[fuchs-kiosk](fuchs-kiosk)
: The main script make sure that it is somewhere where it can be found using the `PATH` variable. (i.e. `/usr/local/bin/` when installing by hand). It is used for starting and managing.

[fuchs-kiosk-ikb-json](fuchs-kiosk-ikb-json)
: This script is a wrapper around the `interactive-kiosk-browser` that allows it to read.

[sway-configuration](sway-configuration)
: A sway configuration that provides some sane visual defautls. When starting whith the `fuchs-kiosk.desktop` file it is expected to be placed under `/usr/share/fuchs-kiosk/sway-configuration`.

[sway-configuration-etc](sway-configuration-etc)
: This file is expected at `/etc/fuchs-kiosk/sway-configuration` by the `sway-configuration` file. It can be customized and also enables the services usually needed at startup.

## Setting up

All scripts support a `--help` flag the prints the most up to date documentation (you can also find the text [inside the script file](fuchs-kiosk)).

In case of manual installation, have a look at the [debian/control](debian/control) file for the dependencies and the [debian/rules](debian/rules) file for where to place files.

To set up create a user for the kiosk, make sure it is in the `video` and `input` groups (needed for sway) and configure the autologin part.

Make sure the user also has a `XDG_RUNTIME_DIR` set by either a pam module or a `.profile`. (Some login managers treat ssh and "on screen" logins differently)

Set the git repository containing your [configuration](json-configuration.md) using `fuchs-kiosk settings set-upstream https://your-codeforge.org/user/repo` and the configuration-name using `fuchs-kiosk settings set-name name-goes-here`. Use `fuchs-kiosk-settings pull` to pull and apply the configuration.

If you know your configuration works use `fuchs-kiosk settings save-for-rollback` to save it for the automatic rollback when a new configuration throws an error.

## Debian Packaging

This repository includes some *very quick and dirty* Debian packaging, this should be cleaned up in the future, but it works well enough for now. You can build the package yourself using git build package (gbp).

```sh
gbp buildpackage --git-force-create --git-cleaner="debuild --no-tgz-check -- clean" --git-upstream-tree=SLOPPY --git-debian-branch="main" -us -uc -sa
debuild --no-tgz-check -- clean
```

## License

The interactive-kiosk-browser is Licensed under a [GNU GPLv3](https://www.gnu.org/licenses/quick-guide-gplv3.html) only License.

Copyright (C) 2023  Stadt Treuchtlingen <admins@treuchtlingen.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

