# ikb json configuration

To configure the [interactive-kiosk-browser](https://codeberg.org/stadt_treuchtlingen/interactive-kiosk-browser) using json, prreapare a directory that will contain:

* one or more `ikb-<config-name>.json` or a `ikb.json` file.
* Custom icon files referenced in the configuration.
* Custom css file(s) referenced in the configuration.

Make this a git repository and make it available somewhere where your `fuchs-kiosk` can pull from.

The `ikb.json` (or a named version) must contain a json dictionary, for options containing lists, the lists can be left empty, other options that are unused can be left out. It is parsed by the [fuchs-kiosk-ikb-json script](fuchs-kiosk-ikb-json).

For a description of what exactly they do see the interactive-kiosk-browser.

Example:

```json
{
	"home": "https://example.org/testpage",
	"_comment_on_fallback": "",
	"fallback": "https://example.org/qr#{{{uri}}}",
	"icon-size": 24,
	"stylesheet": "stylesheet.css",
	"nav-bar": "bottom",
	"error-title": "Entschuldigung,\ndas hat nicht funktioniert.",
	"allow-hosts": [
		"example.org",
		"example.net",
		"search.example.org"
	],
	"nav": [
		{
			"title": "Zurück",
			"url": "about:back",
			"icon": "icons/arrow_back.png",
			"classes": ["back-button"]
		},{
			"title": "Vor",
			"url": "about:forward",
			"icon": "icons/arrow_forward.png",
			"classes": ["forward-button"]
		},{
			"title": "Startseite",
			"url": "about:home",
			"icon": "icons/home.png",
			"classes": ["first-child","clicky"]
		},{
			"title": "Suchen",
			"url": "https://example.org/suche",
			"icon": "icons/search.svg",
			"classes": ["last","clicky"]
		}
	],
	"nav-special": [
		{
			"title": "{{{clock:hour}}}:{{{clock:minute}}}",
			"url": "about:here"
		},{
			"title": "As QR-Code",
			"url": "https://example.org/qr#{{{uri}}}",
			"icon": "icons/qr_code.png",
			"classes": ["last-special","clicky"]
		}
	],
	"cookies": [
		{
			"site": "example.org",
			"name": "cookies",
			"value": "no"
		},{
			"site": "example.com",
			"name": "cookies",
			"value": "no"
		}
	]
}

```

: `nav-bar`
Switches the navigation bar modes between `top`, `bottom` and `no`.
