# interactive-kiosk-browser

A browser that can be used as part of an interactive information kiosk.

Basically a web-view with a loading indicator, a configurable button bar and a list sites it is allowed to visit with some user feedback.

The abolute minimum required for an interactive kiosk system while staying both user and admin friendly.
It is intended for reusing already existing webpages without having to wrap them.

## Configuration

The interactive-kiosk-browser can currently be configured using command line options:

`--home <uri>`
: the next argument is the uri of the homepage

`--css <file>`
: the next argument is a path to a css file (gtk css)

`--icon-size <size>`
: the icon height in pixels for all toolbar icons

`--nav <uri> <label>`
: the next two arguments define the uri and label of a navigation button in the toolbar.
  The same templatinfg functionality as for `--fallback` applies.

`--nav-special <uri> <label>`
: like nav but on the other side of the toolbar.

`--nav-icon <file>`
: Filepath to the icon to be added to the last defined nav.

`--nav-add-class <class>`
: Add a css class to the last specified navbutton.

`--add-cookie <name> <value> <domain> <path> <max_age>`
: Adds a custom cookie that can be used to enable or disable or website functionality.
  Useful for getting rid of cookiebanners (by declining cookies of course).
  Set max_age to -1 to keep the cookie from expiring.

`--allow-host <hostname>`
: Adds a hostname/domainname to the list of domains the browser is allowed to visit.

`--fallback <uri-template>`
: Adds a fallback uri, `{{{uri}}}` will be replaced with an urlencoded version of the curent uri,
  for when a page is not allowed to be visited, not setting results in the browser ignoring the navigation request.
  This i.e. can be used to show a qr code for pages that the browser isn't able or allowed to show directly.

`--bottom-bar`
: Moves the main bar to the bottom of the window, which might be desired for physical accessibility.

`--error-title <title>`
: A title for a generic error message that shows up when the browser runs into network problems.

### Special uris:

`about:here`
: Makes a nav button do nothing, i.e. for displaying a clock.

`about:home`
: Go to the page that is configured as homepage.

`about:back`
: Turns a nav button into a back button.

`about:forward`
: Turns a nav button into a forward button.

### Uri templating:

Use `{{{uri}}}` unside an uri for a navbutton to replace it with an escaped version of the current uri or in case of the fallback uri, the uri that was not allowed to load.

### Name Templating

You can add a clock and date button by including the following in a navbuttons name:
- `{{{clock:minute}}}`
- `{{{clock:hour}}}`
- `{{{clock:day}}}`
- `{{{clock:month}}}`
- `{{{clock:year}}}`

### Styling

Using the `--css` switch you can load one or more stylesheets to style the button bar, since this application is written in gtk you can use the gtk debugger to live edit the css and to inspect which elements have which classes.

The top button bar has the class `toolbar-box` the zoom buttons on the right have the the class `zoom-buttons`. All nav elements have the class `uri-button` (and the additional classes you specified).

The the currently displayed or loading uri equals (or passes a prefix suffix match in case you use templating) the uri the button is for the button gets deactivated, in case of the about:back uri the program tests if the webview can go to a previous page.

You can specify the icon-size using the `--icon-size` switch in pixels for the whole button bar, this will cause all loaded icons to be resized to be $icon-size pixels hight and keep their aspect ratio.

The error message that gets shown when a network error occours replaces the web-view and is tagged using the styleclass `error-message`.
It contains a continer (for ventering purposes) with the following elements:

| Name          | Styleclass    | Content                                                                        |
|---------------|---------------|--------------------------------------------------------------------------------|
| Icon          | `icon`        | Big sad computer icon (`computer-fail-symbolic`)                               |
| Error Title   | `title`       | The title specified with `--error-title`                                       |
| Error Message | `message`     | An error message containing technical information that helps with debugging    |
| Back Button   | `back-button` | A back button that shows up when the page that failed was not the initial page |

### Allowed hosts

The browser has an allowlist with uris and hosts, The user is allowed to visit an uri if:
- it is the uri specified as one of the navigation buttons.
- it is one of the special uris from above
- the hostname in the uri is specified as an `--allowed-host`

## How to build?

### Dependencies
- A working vala compiler
- glib-2.0
- meson
- gtk+-3.0
- webkit2gtk-4.0

If you wannt to use all the scripts (not just `build` and `run`) you also need lua 5.x installed

A guaranteed up to date list of dependencies can be found in the src/meson.build file.

If you added or removed source files use the `update_src_build_files` script, it will atomatically update the src/meson.build file so you don't have to do anything.

### Building and running
To build it, run the `build.sh` script, which will automatically setup
the build folder, run ninja, and put the output in the projects root
directory. The produced binary should be executable, now.

To make development easy, the `run` script calls the `build.sh` script
and then runs whatever is at the output (it will try and fail if there is none).

## Debian Packaging

This repository contais some very *quick and dirty* debian packaging. You can build the package yourself with git build package (gbp).

```sh
gbp buildpackage --git-force-create --git-cleaner="debuild --no-tgz-check -- clean" --git-upstream-tree=SLOPPY --git-debian-branch="main" -us -uc -sa
debuild --no-tgz-check -- clean
```

## License

The interactive-kiosk-browser is Licensed under a [GNU GPLv3](https://www.gnu.org/licenses/quick-guide-gplv3.html) only License.

* Copyright (C) 2021  Baschdel <baschdel@disroot.org>
* Copyright (C) 2023  Stadt Treuchtlingen <admins@treuchtlingen.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
