public class Ikb.Widget.ErrorMessage : Gtk.Box {

	private Gtk.Box center_box = new Gtk.Box(Gtk.Orientation.VERTICAL, 8);
	private Gtk.Button back_button = new Gtk.Button.with_label("Go Back");
	private Gtk.Image back_icon = new Gtk.Image.from_icon_name("go-previous-symbolic", Gtk.IconSize.BUTTON);
	private Gtk.Label title_label = new Gtk.Label("Whoops …");
	private Gtk.Label message_label = new Gtk.Label("Some kind of error happend …\nplease excuse the inconvenience.");
	private Gtk.Image icon = new Gtk.Image.from_icon_name("computer-fail-symbolic", Gtk.IconSize.DIALOG);
	private bool can_go_back = true;

	public signal void on_back_button();
	
	public ErrorMessage() {
		this.get_style_context().add_class("error-message");
		title_label.get_style_context().add_class("title");
		message_label.get_style_context().add_class("message");
		icon.get_style_context().add_class("icon");
		back_button.get_style_context().add_class("back-button");
		back_button.image = back_icon;
		back_icon.show();
		pack_start(center_box);
		center_box.valign = Gtk.Align.CENTER;
		center_box.pack_start(icon,false,false);
		center_box.pack_start(title_label,false,false);
		center_box.pack_start(message_label,false,false);
		center_box.pack_start(back_button,false,false);
		center_box.show();
		icon.show();
		title_label.show();
		message_label.show();
		center_box.margin = 16;
		title_label.wrap = true;
		message_label.wrap = true;
		back_button.clicked.connect(() => { this.on_back_button(); });
		back_button.halign = Gtk.Align.CENTER;
	}

	public void set_content(string title, string? message, string? icon_name, string? back_button_label) {
		back_button.label = back_button_label;
		back_button.visible = can_go_back && back_button_label != null;
		title_label.label = title;
		message_label.label = message;
		message_label.visible = message != null;
		icon.set_from_icon_name(icon_name, Gtk.IconSize.DIALOG);
		icon.set_pixel_size(icon.scale_factor*64);
		icon.visible = icon != null;
	}

	public void set_can_go_back(bool can_go_back) {
		this.can_go_back = can_go_back;
		back_button.visible = can_go_back && back_button.label != null;
	}

	public void set_custom_button_icon_size(int icon_size) {
		back_icon.icon_size = icon_size;
	}

}
