#!/usr/bin/python3

import sys

important_lables = [
		'MemTotal',		# RAM total
		'OverallUsed',
		'MemUsed',
		'SwapTotal',	# swap total
		'SwapUsed',		# swap used
		'Buffers',		# RH6: temporary storage for raw disk blocks.
		'Cached',		# RH6: physical RAM used as cache memory.
		'SwapCached',	# RH6: memory that has once been moved into swap, then back into the main memory, but still also remains in the swapfile. This saves I/O, because the memory does not need to be moved into swap again.
		'Active',		# RH6: buffer or page cache memory that is in active use. This is memory that has been recently used and is usually not reclaimed for other purposes.
		'Inactive',		# RH6: buffer or page cache memory that are free and and available. This is memory that has not been recently used and can be reclaimed for other purposes.
		'Dirty',		# RH6: waiting to be written back to the disk.
		'Writeback',	# RH6: actively being written back to the disk.
	]

with open('/proc/meminfo', 'r') as f:
    lines = f.read().splitlines()

mem = {x.split(':',1)[0] : int( x.split(':',1)[1].replace('kB', '').lstrip().rstrip() ) for x in lines}

mem['MemUsed'] = mem['MemTotal'] - mem['MemFree'] - mem ['Cached'] - mem['SReclaimable'] - mem['Buffers']
mem['SwapUsed'] = mem['SwapTotal'] - mem['SwapFree']

mem['OverallUsed'] = mem['MemUsed'] + mem['SwapUsed']

ratio = float(mem['OverallUsed']) / float(mem['MemTotal']) * 100.0


out = 'MemRatio: %.1f%%/%.1fGB of %.1fGB RAM (and %.1fGB Swap) used' % ( ratio, (mem['OverallUsed']/1024.0/1024.0), (mem['MemTotal']/1024.0/1024.0), (mem['SwapTotal']/1024.0/1024.0) )

if ratio > 150.0:
	exitcode = 2
	exitstr = 'CRITICAL'
elif ratio > 100.0:
	exitcode = 1
	exitstr = 'WARNING'
else:
	exitcode = 0
	exitstr = 'OK'

multiout = []
for label in important_lables:
	multiout.append('%s: %.4fGB' % (label, float(mem[label])/1024.0/1024.0))

perfdata = []
for label in important_lables:
	perfdata.append('%s=%dB;;;;' % (label, mem[label]*1024) )


print(exitstr + ' - ' + out + '|' + ' '.join(perfdata))
print('\n'.join(multiout))
sys.exit(exitcode)

