#!/bin/bash

WARN=30
CRIT=50

SESSIONS="$(x2golistsessions_root)"

CNT="$( printf "%s\n" "$SESSIONS" | wc -l)"

if [ "${CNT}" -gt "${CRIT}" ]; then
	RETCODE=2
elif [ "${CNT}" -gt "${WARN}" ]; then
	RETCODE=1
else
	RETCODE=0
fi

CNT_R="$(printf "%s\n" "$SESSIONS" | grep -c "|R|")"
CNT_S="$(printf "%s\n" "$SESSIONS" | grep -c "|S|")"

STATUS=("OK" "WARNING" "CRITICAL" "UNKNOWN")

echo "X2GO-Sessions ${STATUS[$RETCODE]}: ${CNT} sessions|x2gosessions=${CNT};${WARN};${CRIT};0; x2gosessions_running=${CNT_R};;;0 x2gosessions_suspended=${CNT_S};;;0"
