# Generated by Django 4.1.2 on 2022-11-10 16:56

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    dependencies = [
        ('ipam', '0063_standardize_description_comments'),
        ('extras', '0082_savedfilter'),
        ('tenancy', '0009_standardize_description_comments'),
        ('dcim', '0165_standardize_description_comments'),
    ]

    operations = [
        migrations.CreateModel(
            name='VirtualDeviceContext',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('name', models.CharField(max_length=64)),
                ('status', models.CharField(max_length=50)),
                ('identifier', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('comments', models.TextField(blank=True)),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='vdcs', to='dcim.device')),
                ('primary_ip4', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='ipam.ipaddress')),
                ('primary_ip6', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='ipam.ipaddress')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='vdcs', to='tenancy.tenant')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='interface',
            name='vdcs',
            field=models.ManyToManyField(related_name='interfaces', to='dcim.virtualdevicecontext'),
        ),
        migrations.AddConstraint(
            model_name='virtualdevicecontext',
            constraint=models.UniqueConstraint(fields=('device', 'identifier'), name='dcim_virtualdevicecontext_device_identifier'),
        ),
        migrations.AddConstraint(
            model_name='virtualdevicecontext',
            constraint=models.UniqueConstraint(fields=('device', 'name'), name='dcim_virtualdevicecontext_device_name'),
        ),
    ]
