/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.saa;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.charset.MalformedInputException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import oracle.forms.common.CheckSumUtil;
import oracle.forms.common.Utils;
import oracle.forms.engine.Version;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.saa.FormsAppletIntegration;
import oracle.forms.saa.FormsAppletStub;

public class FormsStandAloneApp
implements Runnable {
    private static final String STANDALONEAPP = "standaloneapp";
    private static final String SHOWCONFIG = "-showConfig";
    private static final String SERVER_URL = "-url";
    private static final String TIMEOUT = "-t";
    private static final String JAVA_CODEBASE = "CODEBASE";
    private static final String JAVA_ARCHIVE = "ARCHIVE";
    private static final String FORMSSAL = "frmsal";
    private static final String DOCBASE = "DOCUMENTBASE";
    private static final String IGNORE_SAA_CACHE = "ignoreSaaCache";
    private static final String TIMESTAMP_MESSAGES = "-timestampMessages";
    private static final String SLEEP = "-sleep";
    private URL mServerURL = null;
    private String mQuery = null;
    private String mTarget = "";
    private int mTimeout = 60000;
    private boolean mShowConfig = false;
    private boolean mDebugOpenConn = false;
    private boolean mDebugCookies = false;
    private boolean mDebugLaunchTiming = false;
    private long[] mSleep = null;
    private boolean mTimestampMessages = this.mDebugLaunchTiming;
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("[yyyy-MM-dd'T'HH:mm:ss.SSSX:00] ");
    private TreeMap<String, String> mAppletParams = null;
    private String[] mArgs;
    private CookieManager mManager;
    protected final MessageGenerator mEMG = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault()){

        @Override
        protected boolean showMessageKey(String string) {
            char c = string.charAt(6);
            return c < '7' || c > '8';
        }
    };

    private void println(String string) {
        if (this.mTimestampMessages) {
            string = this.mDateFormat.format(new Date()) + string;
        }
        System.out.println(string);
    }

    private void println(Object object) {
        if (this.mTimestampMessages) {
            System.out.print(this.mDateFormat.format(new Date()));
        }
        System.out.println(object);
    }

    private boolean isRedirect(int n) {
        return n != 200 && (n == 302 || n == 301 || n == 303);
    }

    private HttpURLConnection openConn(int n) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection;
        URL uRL = this.mServerURL;
        while (true) {
            httpURLConnection = (HttpURLConnection)this.mServerURL.openConnection();
            if (this.mDebugOpenConn) {
                this.println("openConn(): open " + this.mServerURL.toString());
            }
            if (n == 0) {
                httpURLConnection.setRequestProperty("User-Agent", Version.getStandloneLauncherString());
            } else {
                httpURLConnection.setRequestProperty("Pragma", Integer.toString(n));
            }
            httpURLConnection.setRequestProperty("Accept", "text/*");
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (n == 0) {
                httpURLConnection.setReadTimeout(this.mTimeout);
            }
            httpURLConnection.setConnectTimeout(this.mTimeout);
            if (uRL == null || n > 0) {
                if (this.mDebugOpenConn) {
                    this.println("openConn(): connecting");
                }
                httpURLConnection.connect();
                break;
            }
            httpURLConnection.setInstanceFollowRedirects(false);
            if (this.mDebugOpenConn) {
                this.println("openConn(): response code is " + httpURLConnection.getResponseCode());
            }
            if (!this.isRedirect(httpURLConnection.getResponseCode())) break;
            String string = httpURLConnection.getHeaderField("Location");
            if (this.mDebugOpenConn) {
                this.println("openConn(): response is redirect; Location==" + string);
            }
            if (string == null || !string.startsWith("http")) {
                if (this.mDebugOpenConn) {
                    this.println("openConn(): redirection failed");
                }
                this.mServerURL = uRL;
                uRL = null;
                continue;
            }
            this.mServerURL = new URL(string);
        }
        this.setBaseTarget();
        return httpURLConnection;
    }

    private BufferedReader getResponseReader(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        String[] stringArray;
        String[] stringArray2;
        String string2;
        InputStream inputStream = httpURLConnection.getInputStream();
        String string3 = "ISO-8859-1";
        if ("gzip".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            inputStream = new GZIPInputStream(inputStream, 4096);
        }
        if ((string2 = httpURLConnection.getContentType()) != null && (stringArray2 = string2.split(";")).length == 2 && (stringArray = (string = stringArray2[1]).split("=")).length == 2 && stringArray[0].trim().equalsIgnoreCase("charset")) {
            string3 = stringArray[1].trim();
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string3);
        return new BufferedReader(inputStreamReader, 8192);
    }

    private void printUsage() {
        this.println(this.mEMG.getMessage("FRM-92893"));
        this.println(this.mEMG.getMessage("FRM-92892", Version.getString()));
        this.println(this.mEMG.getMessage("FRM-92890", FORMSSAL));
    }

    private void setBaseTarget() {
        if (this.mServerURL != null) {
            int n = this.mServerURL.getPort();
            if (n == -1) {
                n = this.mServerURL.getDefaultPort();
            }
            this.mTarget = this.mServerURL.getProtocol() + "://" + this.mServerURL.getHost();
            if (n != -1) {
                this.mTarget = this.mTarget + ":" + n;
            }
        }
    }

    private String getArchiveURL(String string, String string2) {
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            return string2;
        }
        if (string2.startsWith("/")) {
            return this.mTarget + string2;
        }
        return this.mTarget + string + "/" + string2;
    }

    private String createSubDir(String string) {
        String string2 = string.endsWith(File.separator) ? "" : File.separator;
        String string3 = string.concat(string2 + FORMSSAL + File.separator + this.mServerURL.getHost() + File.separator + Version.getString());
        File file = new File(string3);
        if (!file.exists() && !file.mkdirs()) {
            string3 = string;
        }
        return string3;
    }

    private String getArchiveDirLocation() {
        String string = System.getProperty("java.io.tmpdir");
        string = string != null && !string.isEmpty() ? this.createSubDir(string) : ((string = System.getProperty("user.home")) != null && !string.isEmpty() ? this.createSubDir(string) : ".");
        return string;
    }

    private boolean processCmdLineParameters() {
        int n = this.mArgs.length;
        boolean bl = false;
        int n2 = 0;
        block6: while (n2 < n) {
            int n3;
            String string;
            String string2 = this.mArgs[n2].trim();
            if (++n2 < n) {
                string = this.mArgs[n2].trim();
                ++n2;
            } else {
                return false;
            }
            if (string2.equalsIgnoreCase(SERVER_URL)) {
                if (!string.startsWith("http")) {
                    string = "http://" + string;
                }
                try {
                    this.mServerURL = new URL(string);
                    this.mQuery = this.mServerURL.getQuery();
                    n3 = this.mQuery != null && !this.mQuery.isEmpty() ? 38 : 63;
                    this.mServerURL = new URL(string + (char)n3 + STANDALONEAPP + "=1");
                    this.mQuery = this.mServerURL.getQuery();
                    bl = true;
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    this.println(malformedURLException.getMessage());
                    return false;
                }
            }
            if (string2.equalsIgnoreCase(TIMEOUT)) {
                try {
                    this.mTimeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.println(this.mEMG.getMessage("FRM-92494", this.mTimeout));
                }
                continue;
            }
            if (string2.equalsIgnoreCase(SHOWCONFIG)) {
                if (!string.equalsIgnoreCase("true")) continue;
                this.mShowConfig = true;
                continue;
            }
            if (string2.equalsIgnoreCase(TIMESTAMP_MESSAGES)) {
                if (!string.equalsIgnoreCase("true")) continue;
                this.mTimestampMessages = true;
                continue;
            }
            if (!this.mDebugLaunchTiming || !string2.equalsIgnoreCase(SLEEP)) continue;
            n3 = 0;
            this.mSleep = new long[4096];
            for (String string3 : string.split(",")) {
                long l;
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                if (l < 0L) {
                    this.println("invalid -sleep");
                    this.mSleep = null;
                    continue block6;
                }
                this.mSleep[n3++] = l * 1000L;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getAppletParamsFromServer() {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            int n;
            int n2;
            CharSequence charSequence;
            String string;
            HttpURLConnection httpURLConnection;
            int n3;
            this.mAppletParams = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            String string2 = System.getProperty("line.separator");
            if (this.mSleep != null) {
                this.println("standaloneapp=1 request sent");
            }
            if ((n3 = (httpURLConnection = this.openConn(0)).getResponseCode()) != 200) {
                this.println(this.mEMG.getMessage("FRM-92497", n3, httpURLConnection.getResponseMessage()));
                boolean bl = false;
                return bl;
            }
            if (this.mSleep != null) {
                this.println("standaloneapp=1 response received");
            }
            if ((string = (bufferedReader = this.getResponseReader(httpURLConnection)).readLine()) == null) {
                this.println(this.mEMG.getMessage("FRM-92898"));
                boolean bl = false;
                return bl;
            }
            if (string.startsWith("/")) {
                void var8_33;
                Object object;
                if (this.mDebugCookies) {
                    try {
                        this.println("readLine: " + string);
                        for (HttpCookie httpCookie : this.mManager.getCookieStore().getCookies()) {
                            this.println("Retrieved cookie: " + httpCookie + "; MaxAge=" + httpCookie.getMaxAge() + "; Domain=" + httpCookie.getDomain() + "; Path=" + httpCookie.getPath() + (httpCookie.isHttpOnly() ? "; HttpOnly" : ""));
                        }
                        for (URI uRI : this.mManager.getCookieStore().getURIs()) {
                            this.println("Found uri: " + uRI);
                        }
                    }
                    catch (Exception exception) {
                        this.println("Unable to get cookie");
                        exception.printStackTrace();
                    }
                }
                Iterator<URI> iterator = this.mQuery.substring(0, this.mQuery.length() - 1);
                charSequence = new StringBuilder();
                boolean bl = false;
                n2 = string.lastIndexOf(61);
                n = string.lastIndexOf(59, n2 - 1);
                String string3 = string.substring(n + 1, n2);
                URI uRI = null;
                try {
                    uRI = new URI(this.mTarget);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                List<HttpCookie> list = this.mManager.getCookieStore().get(uRI);
                for (HttpCookie httpCookie : list) {
                    if (this.mDebugCookies) {
                        this.println("cookie name: " + httpCookie.getName());
                    }
                    if (!httpCookie.getName().equalsIgnoreCase(string3)) continue;
                    bl = true;
                    if (!httpCookie.isHttpOnly()) break;
                    ((StringBuilder)charSequence).append(';');
                    ((StringBuilder)charSequence).append(httpCookie.getName());
                    ((StringBuilder)charSequence).append(string.substring(n2));
                    if (httpCookie.getPath() != null) {
                        ((StringBuilder)charSequence).append("; Path=");
                        ((StringBuilder)charSequence).append(httpCookie.getPath());
                    }
                    ((StringBuilder)charSequence).append('\n');
                    break;
                }
                if (bl) {
                    for (HttpCookie httpCookie : list) {
                        if (httpCookie.isHttpOnly() || httpCookie.getMaxAge() != -1L) continue;
                        ((StringBuilder)charSequence).append(httpCookie.getName());
                        ((StringBuilder)charSequence).append('=');
                        ((StringBuilder)charSequence).append(httpCookie.getValue());
                        if (httpCookie.getPath() != null) {
                            ((StringBuilder)charSequence).append("; Path=");
                            ((StringBuilder)charSequence).append(httpCookie.getPath());
                        }
                        ((StringBuilder)charSequence).append('\n');
                    }
                    ((StringBuilder)charSequence).append(";;");
                    ((StringBuilder)charSequence).append(this.mTarget);
                    object = ((StringBuilder)charSequence).toString();
                    if (this.mDebugCookies) {
                        this.println("hashParamString:\n" + (String)object);
                    }
                    string = string.substring(0, n);
                    String string4 = this.mTarget + string + "?ifhash=" + Utils.urlEncode((String)object) + "&" + iterator + "3";
                } else {
                    String string5 = this.mTarget + string + "?" + iterator + "3";
                }
                object = new Browser((String)var8_33);
                Thread thread = new Thread((Runnable)object);
                thread.start();
                int n4 = 0;
                do {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String string6 = this.mTarget + string + "?" + iterator + "2";
                    this.mServerURL = new URL(string6);
                    if (this.mSleep != null) {
                        this.println("standaloneapp=2 sleep");
                        Thread.sleep(this.mSleep[n4 + 1]);
                        this.println("standaloneapp=2 request sent");
                    }
                    if ((n3 = (httpURLConnection = this.openConn(++n4)).getResponseCode()) != 200) {
                        this.println(this.mEMG.getMessage("FRM-92497", n3, httpURLConnection.getResponseMessage()));
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (this.mSleep != null) {
                        this.println("standaloneapp=2 response received");
                    }
                    if ((string = (bufferedReader = this.getResponseReader(httpURLConnection)).readLine()) != null) continue;
                    this.println(this.mEMG.getMessage("FRM-92898"));
                    boolean bl3 = false;
                    return bl3;
                } while (string.startsWith("/"));
            }
            if (string.startsWith("FRM-")) {
                if (string.length() == 4 && (string = bufferedReader.readLine()) == null) {
                    boolean bl = false;
                    return bl;
                }
                do {
                    this.println(string);
                } while ((string = bufferedReader.readLine()) != null);
                boolean bl = false;
                return bl;
            }
            if (this.mShowConfig) {
                this.println(this.mEMG.getMessage("FRM-92894"));
            }
            boolean bl = false;
            do {
                if (!(string = string.trim()).startsWith("#")) {
                    if (string.length() >= 5 && (string.substring(0, 5).equalsIgnoreCase("<html") || string.substring(0, 5).equalsIgnoreCase("<jnlp"))) {
                        bl = true;
                    } else {
                        String[] stringArray = string.split("=", 2);
                        if (stringArray.length == 2) {
                            charSequence = stringArray[0].trim();
                            String string7 = stringArray[1].trim();
                            this.mAppletParams.put((String)charSequence, string7);
                            if (this.mShowConfig) {
                                if (((String)charSequence).equalsIgnoreCase("serverurl") && (n2 = string7.indexOf(59)) >= 0) {
                                    n = string7.indexOf(63);
                                    if (n < 0) {
                                        n = string7.length();
                                    }
                                    string7 = string7.substring(0, n2) + string7.substring(n);
                                }
                                this.println("    " + (String)charSequence + "=" + string7);
                            }
                        }
                    }
                }
                stringBuilder.append(string);
                stringBuilder.append(string2);
            } while ((string = bufferedReader.readLine()) != null);
            if (this.mAppletParams.size() != 0 && !bl) {
                String string8 = this.mAppletParams.get(DOCBASE);
                if (string8 == null || string8.equals("")) {
                    this.mAppletParams.put(DOCBASE, this.mServerURL.getFile().toString());
                }
                this.mAppletParams.put(STANDALONEAPP, "true");
                boolean bl4 = true;
                return bl4;
            }
            this.println(this.mEMG.getMessage("FRM-92492"));
            this.println(stringBuilder.toString());
            boolean bl5 = false;
            return bl5;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.println(socketTimeoutException.getMessage());
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            this.println(malformedURLException.getMessage());
            return false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.println(unsupportedEncodingException.getMessage());
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            this.println(unknownHostException);
            return false;
        }
        catch (IOException iOException) {
            this.println(iOException.getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean getArchivesFromServer() {
        boolean bl = false;
        String string = this.mAppletParams.get(JAVA_CODEBASE);
        String string2 = this.mAppletParams.get(JAVA_ARCHIVE);
        boolean bl2 = "true".equalsIgnoreCase(this.mAppletParams.get(IGNORE_SAA_CACHE));
        String string3 = this.getArchiveDirLocation();
        this.println(this.mEMG.getMessage(bl2 ? "FRM-92895" : "FRM-92891", string3));
        if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            Method method;
            string = string.trim();
            String[] stringArray = string2.split(",");
            int n = stringArray.length;
            if (n == 0) {
                return bl;
            }
            try {
                method = this.getClass().getClassLoader().getClass().getDeclaredMethod("appendClassPath", URL.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.println(noSuchMethodException.getMessage());
                return bl;
            }
            for (int i = 0; i < n; ++i) {
                boolean bl3 = bl2;
                String string4 = stringArray[i].trim();
                try {
                    Object object;
                    File file;
                    String string5 = this.getArchiveURL(string, string4);
                    int n2 = string5.lastIndexOf(47);
                    if (n2 < 0) {
                        this.println(this.mEMG.getMessage("FRM-92495", string5));
                        continue;
                    }
                    String string6 = string3;
                    String string7 = string5.substring(n2 + 1);
                    String string8 = string5.substring(0, n2);
                    String string9 = CheckSumUtil.getMD5CheckSumOfString(string8, 36);
                    if (string9 == null) {
                        string9 = "\".\"";
                        bl3 = true;
                    } else {
                        file = new File(string6 = string6 + File.separator + string9);
                        if (!file.exists() && !file.mkdir()) {
                            string6 = string3;
                            string9 = "\".\"";
                            bl3 = true;
                        }
                    }
                    file = new File(string6 + File.separator + string7);
                    long l = bl3 ? 0L : file.lastModified();
                    URL uRL = new URL(string5);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setConnectTimeout(this.mTimeout);
                    httpURLConnection.setReadTimeout(this.mTimeout);
                    if (l > 0L) {
                        httpURLConnection.setIfModifiedSince(l);
                    }
                    httpURLConnection.connect();
                    int n3 = httpURLConnection.getResponseCode();
                    if (n3 == 304) {
                        this.println(this.mEMG.getMessage("FRM-92896", string4, string9));
                    } else {
                        this.println(this.mEMG.getMessage("FRM-92897", string4, string9));
                        if (n3 != 200) {
                            this.println(this.mEMG.getMessage("FRM-92290", n3, httpURLConnection.getResponseMessage()));
                            bl = false;
                            break;
                        }
                        object = new BufferedInputStream(httpURLConnection.getInputStream());
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        int n4 = 0;
                        byte[] byArray = new byte[1024];
                        while ((n4 = ((BufferedInputStream)object).read(byArray, 0, 1024)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n4);
                        }
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        ((BufferedInputStream)object).close();
                        file.setLastModified(httpURLConnection.getLastModified());
                    }
                    object = file.toURI().toURL();
                    method.invoke((Object)this.getClass().getClassLoader(), object);
                    bl = true;
                    continue;
                }
                catch (MalformedInputException malformedInputException) {
                    this.println(malformedInputException.getMessage());
                    bl = false;
                    break;
                }
                catch (IOException iOException) {
                    this.println(iOException.getMessage());
                    bl = false;
                    break;
                }
                catch (SecurityException securityException) {
                    this.println(securityException.getMessage());
                    bl = false;
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.println(illegalAccessException.getMessage());
                    bl = false;
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.println(invocationTargetException.getMessage());
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = System.getProperty("java.class.path").split(File.pathSeparator);
        int n = stringArray2.length;
        URL[] uRLArray = new URL[n];
        while (n > 0) {
            uRLArray[--n] = new File(stringArray2[n]).toURI().toURL();
        }
        FormsURLClassLoader formsURLClassLoader = new FormsURLClassLoader(uRLArray, ClassLoader.getSystemClassLoader().getParent());
        Class<?> clazz = Class.forName("oracle.forms.saa.FormsStandAloneApp", true, formsURLClassLoader);
        clazz.getDeclaredMethod("run", stringArray.getClass()).invoke(clazz.newInstance(), new Object[]{stringArray});
    }

    public void run(String[] stringArray) {
        this.mArgs = stringArray;
        this.run();
    }

    @Override
    public void run() {
        System.out.println();
        this.mManager = new CookieManager();
        this.mManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(this.mManager);
        if (!this.processCmdLineParameters()) {
            this.printUsage();
            return;
        }
        if (!this.getAppletParamsFromServer()) {
            return;
        }
        if (!this.getArchivesFromServer()) {
            this.println(this.mEMG.getMessage("FRM-92491"));
            return;
        }
        FormsAppletIntegration formsAppletIntegration = new FormsAppletIntegration(new FormsAppletStub(this.mTarget, this.mAppletParams));
        formsAppletIntegration.startApplet();
    }

    class Browser
    implements Runnable {
        private String mServerURL;

        public Browser(String string) {
            this.mServerURL = string;
        }

        @Override
        public void run() {
            if (FormsStandAloneApp.this.mSleep != null) {
                FormsStandAloneApp.this.println("standaloneapp=3 sleep");
                try {
                    Thread.sleep(FormsStandAloneApp.this.mSleep[0]);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FormsStandAloneApp.this.println("standaloneapp=3 request launched");
            }
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(this.mServerURL));
                }
                catch (IOException | URISyntaxException exception) {
                    FormsStandAloneApp.this.println(exception.getMessage());
                }
            } else {
                MessageGenerator messageGenerator = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault());
                FormsStandAloneApp.this.println(messageGenerator.getMessage("FRM-92493"));
            }
        }
    }

    public static class FormsURLClassLoader
    extends URLClassLoader {
        public FormsURLClassLoader() {
            super(new URL[0]);
        }

        public FormsURLClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public FormsURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public void appendClassPath(URL uRL) {
            this.addURL(uRL);
        }
    }
}

