/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common.ssl;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.forms.common.ssl.CertDialogUtility;
import oracle.forms.registry.MessageGenerator;

public class CertificateHandler {
    private File mTrustStoreFile;
    private char[] mPassphrase;
    private KeyStore mTrustStore;
    private boolean mShowDialog;
    private boolean mDebug;
    private static int mRetryCount = 0;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
    protected static final MessageGenerator mEMG = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault()){

        @Override
        protected boolean showMessageKey(String string) {
            char c = string.charAt(6);
            return c < '7' || c > '8';
        }
    };

    public CertificateHandler(String string, char[] cArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        File file;
        String string2 = File.separator + "Oracle" + File.separator + "forms";
        String string3 = System.getProperty("user.dir");
        if (string == null || string.length() == 0) {
            String string4 = System.getProperty("user.home");
            if (string4 == null || string4.isEmpty()) {
                string4 = string3;
            }
            string = string4 + string2;
        }
        if (!this._createDirs(file = new File(string)) && !this._createDirs(file = new File(string = string3 + string2))) {
            string = string3;
        }
        string = string + File.separator + "formstruststore";
        this.mTrustStoreFile = new File(string);
        this.mShowDialog = bl;
        this.mDebug = bl2;
        if (cArray == null || cArray.length == 0) {
            cArray = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
        }
        this.mPassphrase = cArray;
        if (bl3 && !bl5) {
            new CertDialogUtility();
            throw new IOException();
        }
        if (!this._createCustomTrustStore(bl3)) {
            throw new IOException();
        }
        if (bl3 && bl4) {
            this._updateTrustStore();
        }
    }

    private boolean _createDirs(File file) {
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createCustomTrustStore(boolean bl) {
        if (this.mTrustStoreFile.exists() && !this.mTrustStoreFile.canWrite()) {
            System.out.println(mEMG.getMessage("FRM-92513") + this.mTrustStoreFile.getAbsolutePath());
            return false;
        }
        if (bl) {
            return this._changeStorePwd(this.mTrustStoreFile);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            this.mTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.mTrustStoreFile.exists()) {
                fileInputStream = new FileInputStream(this.mTrustStoreFile);
                this.mTrustStore.load(fileInputStream, this.mPassphrase);
            } else {
                this.mTrustStore.load(null, this.mPassphrase);
                fileOutputStream = new FileOutputStream(this.mTrustStoreFile);
                this.mTrustStore.store(fileOutputStream, this.mPassphrase);
            }
            this._updateTrustStore();
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException) {
                boolean bl2 = this._fetchPassword();
                return bl2;
            }
            System.out.println(mEMG.getMessage("FRM-92512"));
            if (this.mDebug) {
                iOException.printStackTrace();
            }
            boolean bl3 = false;
            return bl3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println(mEMG.getMessage("FRM-92511", generalSecurityException.getMessage()));
            if (this.mDebug) {
                generalSecurityException.printStackTrace();
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public boolean checkCerts(URL uRL) {
        String string = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        SavingTrustManager savingTrustManager = null;
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.mTrustStore);
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            savingTrustManager = new SavingTrustManager(x509TrustManager);
            sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            if (this.mDebug) {
                System.out.println(mEMG.getMessage("FRM-92874", string));
                System.out.println(mEMG.getMessage("FRM-92875", Integer.toString(n)));
            }
            System.out.println(mEMG.getMessage("FRM-92862", string, Integer.toString(n)));
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            sSLSocket.setSoTimeout(10000);
            System.out.println(mEMG.getMessage("FRM-92863"));
            sSLSocket.startHandshake();
            sSLSocket.close();
            System.out.println();
            System.out.println(mEMG.getMessage("FRM-92864"));
        }
        catch (SSLException sSLException) {
            if (!this.mShowDialog) {
                CertDialogUtility certDialogUtility = new CertDialogUtility(this, this.mDebug, false);
                if (certDialogUtility.dialog(savingTrustManager.chain, string, n) && certDialogUtility.getVal()) {
                    return this._downloadCerts(string, savingTrustManager);
                }
                return false;
            }
            return this._downloadCerts(string, savingTrustManager);
        }
        catch (Exception exception) {
            System.out.println(mEMG.getMessage("FRM-92511", exception.getMessage()));
            if (this.mDebug) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _downloadCerts(String string, SavingTrustManager savingTrustManager) {
        Object object;
        Object object2;
        X509Certificate[] x509CertificateArray = savingTrustManager.chain;
        if (x509CertificateArray == null) {
            System.out.println(mEMG.getMessage("FRM-92095"));
            return false;
        }
        System.out.println();
        System.out.println(mEMG.getMessage("FRM-92867", x509CertificateArray.length));
        System.out.println();
        if (this.mDebug) {
            try {
                object2 = MessageDigest.getInstance("SHA1");
                object = MessageDigest.getInstance("MD5");
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    System.out.println(" " + (i + 1) + " Subject " + x509Certificate.getSubjectDN());
                    System.out.println("   Issuer  " + x509Certificate.getIssuerDN());
                    ((MessageDigest)object2).update(x509Certificate.getEncoded());
                    System.out.println("   sha1    " + this.toHexString(((MessageDigest)object2).digest()));
                    ((MessageDigest)object).update(x509Certificate.getEncoded());
                    System.out.println("   md5     " + this.toHexString(((MessageDigest)object).digest()));
                    System.out.println();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        object2 = x509CertificateArray[0];
        object = string;
        OutputStream outputStream = null;
        try {
            this.mTrustStore.setCertificateEntry((String)object, (Certificate)object2);
            outputStream = new FileOutputStream(this.mTrustStoreFile);
            this.mTrustStore.store(outputStream, this.mPassphrase);
        }
        catch (Exception exception) {
            System.out.println(mEMG.getMessage("FRM-92511", exception.getMessage()));
            if (this.mDebug) {
                exception.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.mDebug) {
            System.out.println();
            System.out.println(object2);
            System.out.println();
        }
        System.out.println(mEMG.getMessage("FRM-92865", object));
        return true;
    }

    public String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (int n : byArray) {
            stringBuilder.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            stringBuilder.append(HEXDIGITS[n & 0xF]);
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordCorrect(char[] cArray) {
        FileInputStream fileInputStream = null;
        boolean bl = true;
        try {
            fileInputStream = new FileInputStream(this.mTrustStoreFile);
            this.mTrustStore.load(fileInputStream, cArray);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException) {
                bl = false;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println(mEMG.getMessage("FRM-92511", generalSecurityException.getMessage()));
            boolean bl2 = false;
            return bl2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.mPassphrase = cArray;
        return bl;
    }

    private boolean _fetchPassword() {
        CertDialogUtility certDialogUtility = new CertDialogUtility(this, this.mDebug, true);
        if (certDialogUtility.getIsValid()) {
            this._updateTrustStore();
            return true;
        }
        return false;
    }

    private void _updateTrustStore() {
        System.setProperty("javax.net.ssl.trustStore", this.mTrustStoreFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", new String(this.mPassphrase));
        System.out.println(mEMG.getMessage("FRM-92866", System.getProperty("javax.net.ssl.trustStore")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _changeStorePwd(File file) {
        boolean bl = true;
        String string = mEMG.getMessage("FRM-92871");
        String string2 = mEMG.getMessage("FRM-92872");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                this.mTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] cArray = CertificateHandler._getPassWord(string);
                ++mRetryCount;
                this.mTrustStore.load(fileInputStream, cArray);
                char[] cArray2 = CertificateHandler._getPassWord(string2);
                if (this._confirmPassword(cArray2)) {
                    fileOutputStream = new FileOutputStream(file);
                    this.mTrustStore.store(fileOutputStream, cArray2);
                    fileOutputStream.close();
                    this.mPassphrase = cArray2;
                    System.out.println(mEMG.getMessage("FRM-92868", file));
                }
                bl = false;
            }
            catch (IOException iOException) {
                try {
                    fileInputStream.close();
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (iOException.getCause() instanceof UnrecoverableKeyException) {
                    if (mRetryCount < 3) {
                        System.out.println(mEMG.getMessage("FRM-92310"));
                        bl = this._changeStorePwd(this.mTrustStoreFile);
                    }
                    System.out.println(mEMG.getMessage("FRM-92311"));
                    bl = false;
                }
                System.out.println(mEMG.getMessage("FRM-92512"));
                if (this.mDebug) {
                    iOException.printStackTrace();
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception exception) {
                System.out.println(mEMG.getMessage("FRM-92511", exception.getMessage()));
                if (this.mDebug) {
                    exception.printStackTrace();
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    fileInputStream.close();
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            System.out.println(mEMG.getMessage("FRM-92869", file));
            try {
                char[] cArray = CertificateHandler._getPassWord(string2);
                if (this._confirmPassword(cArray)) {
                    this.mTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    this.mTrustStore.load(null, cArray);
                    fileOutputStream = new FileOutputStream(file);
                    this.mTrustStore.store(fileOutputStream, cArray);
                    this.mPassphrase = cArray;
                } else {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                System.out.println(mEMG.getMessage("FRM-92512"));
                if (this.mDebug) {
                    iOException.printStackTrace();
                }
                boolean bl4 = false;
                return bl4;
            }
            catch (Exception exception) {
                System.out.println(mEMG.getMessage("FRM-92511", exception.getMessage()));
                if (this.mDebug) {
                    exception.printStackTrace();
                }
                boolean bl5 = false;
                return bl5;
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private static char[] _getPassWord(String string) {
        System.out.println();
        Console console = System.console();
        char[] cArray = console.readPassword(string, new Object[0]);
        if (cArray.length != 0 && cArray != null) {
            return cArray;
        }
        System.out.println(mEMG.getMessage("FRM-92312"));
        return CertificateHandler._getPassWord(string);
    }

    private boolean _confirmPassword(char[] cArray) {
        String string = mEMG.getMessage("FRM-92873");
        boolean bl = false;
        for (int i = 0; i < 3 && !bl; ++i) {
            char[] cArray2 = CertificateHandler._getPassWord(string);
            if (new String(cArray).equals(new String(cArray2))) {
                bl = true;
                continue;
            }
            if (i >= 2) continue;
            System.out.println(mEMG.getMessage("FRM-92310"));
        }
        if (!bl) {
            System.out.println(mEMG.getMessage("FRM-92311"));
        }
        return bl;
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager mTm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.mTm = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.mTm.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

