/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class Utils {
    private Utils() {
    }

    public static boolean getBoolEnvValue(String string, boolean bl) {
        switch (string.length()) {
            case 0: {
                return bl;
            }
            case 1: {
                switch (string.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (string) {
                    case "NO": 
                    case "No": 
                    case "no": {
                        return false;
                    }
                }
                break;
            }
            case 5: {
                switch (string) {
                    case "FALSE": 
                    case "False": 
                    case "false": {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static final String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final String canonicalLowerCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            cArray[i] = Character.toLowerCase(Character.toUpperCase(cArray[i]));
        }
        return new String(cArray);
    }

    public static final boolean containsCookie(String string, String string2, boolean bl) {
        if (string == null) {
            return false;
        }
        if (bl) {
            string2 = string2 + "=";
        }
        return string.startsWith(string2) || string.contains("; " + string2);
    }
}

