#!/bin/bash

set -e

PACKAGE_NAME="$(basename $(realpath .) | sed -e 's/^package\.//' -e 's/^code-[a-z]*\.//' -e 's/^tool\.//' )"
MAINTAINER_NAME="$(git config --get user.name)"
MAINTAINER_EMAIL="$(git config --get user.email)"
VCS_GIT="$(git remote get-url origin | sed -E -e 's|^git@|https://|' -e 's|([a-z]):([a-zA-Z_])|\1/\2|')"
ARCHITECTURE="any"

read -e -i "$PACKAGE_NAME" -p "Package Name: " PACKAGE_NAME
read -e -i "$MAINTAINER_NAME" -p "Maintainer Name: " MAINTAINER_NAME
read -e -i "$MAINTAINER_EMAIL" -p "Maintainer E-Mail: " MAINTAINER_EMAIL
read -e -i "$VCS_GIT" -p "Version Control Git Url (Usually ends in .git): " VCS_GIT
read -e -i "$( printf "%s" "$VCS_GIT" | sed "s/\.git$//" )" -p "Version Control Browser Url: " VCS_BROWSER

echo "Choose a package architecture, any for compiled packages, all for archtexture independed."
read -e -i "$ARCHITECTURE" -p "Package architecture: " ARCHITECTURE

read -e -p "Make this directory a package? [y/N] " CONFIRMATION

if [ ! "_$CONFIRMATION" = "_y" ] && [ ! "_$CONFIRMATION" = "_Y" ] ; then
	echo "Canceled!"
	exit 1
fi


mkdir -p debian/source
echo "3.0 (quilt)" > debian/source/format

cat > debian/rules <<EOF
#!/usr/bin/make -f
# -*- makefile -*-
# Sample debian/rules that uses debhelper.
# This file was originally written by Joey Hess and Craig Small.
# As a special exception, when this file is copied by dh-make into a
# dh-make output file, you may use that output file without restriction.
# This special exception was added by Craig Small in version 0.37 of dh-make.

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

%:
	dh \$@

#override_dh_install:
#	cp -a \$(CURDIR)/something \$(CURDIR)/debian/$PACKAGE_NAME/something
EOF

chmod +x debian/rules

cat > debian/changelog <<EOF
$PACKAGE_NAME (1.0.0-1) unstable; urgency=medium

  * Initial release

 -- $MAINTAINER_NAME <$MAINTAINER_EMAIL>  $(date -R)
EOF

cat > debian/control <<EOF
Source: $PACKAGE_NAME
Section: x11
Priority: optional
Maintainer: $MAINTAINER_NAME <$MAINTAINER_EMAIL>
Build-Depends: debhelper-compat (= 13)
Standards-Version: 4.5.1
Vcs-Browser: $VCS_BROWSER
Vcs-Git: $VCS_GIT

Package: $PACKAGE_NAME
Architecture: $ARCHITECTURE
Depends: \${misc:Depends}
Description: Package description here …
EOF
