# Debian Packaging tools for Treuchtlingen

These tools are intended to make packaging as painless as possible for INTERNAL packages. They make some assumptions and compromises one does NOT want in a package available to the general public.

All these scripts assume that they are run from a package root directory which is a git repository and has a `debian/` folder in it.

Dependencies:
* `git-buildpackage`
* `debhelper`
* `git`

## `bootstrap_deb.sh`

This script will create the `debian/` folder with some scaffholding in it to have a minimal base for building a package on top of. This script does not add any special values, it only helps with creating metadata that the debian packaging tools need.

Run in a git repository that may or may not have already existing files in it to turn it into something that can build as debian package.

You must edit the `debian/control` and `debian/changelog` files, they are only scaffolds.

## `update_deb_changelog.sh`

This script will use `gbp` (git build package) to generate a base changelog entry with the *package version* incremented and open it in your favorite (configured) text-editor. *Important:* you have to bump at least the minor version and reset the package version to `-1` (i.e. `0.1.0-2` to `0.1.1-1`) build a package that won't be rejected by the package server.

## `build_deb.sh`

Makes some assumptions and builds the package with `gbp buildpackage`, the resulting packages are moved to the `output_debian` folder. It also cleans up after itself on success, it doen't on failure to make debugging easier, run `dh_clean` to clean up by hand after a failed build.

If run again it may complain about moving unchanged files, this is okay.

NOTE: It also adds the `output_debian/` folder to the repositories `.gitignore` to make less easy to commit built packages by accident.

## `upload_deb.sh`

This script uploads the files from the `output_debian/` folder to the internal packaging server to the `treuchtlingen` repository, currently it can NOT upload to the `extra` repo.

## Forgejo Action

Using this repository as an forgejo action will run `build_deb.sh`.

```yaml
- uses: https://git-intern.treuchtlingen.stadt/Stadt_Treuchtlingen/tool.debian-buildscripts@main
```

To get the package output as an artefact use:

```yaml
- uses: https://codeberg.org/shrimp-ci/upload-artifact@v1
  with:
    upload: "output_debian/"
    name: "debian-package"
```
