// This is the Debian specific preferences file for Firefox ESR
// You can make any change in here, it is the purpose of this file.
// You can, with this file and all files present in the
// /etc/firefox-esr directory, override any preference you can see in
// about:config.
//
// Note that pref("name", value, locked) is allowed in these
// preferences files if you don't want users to be able to override
// some preferences.

pref("extensions.update.enabled", true);

// Use LANG environment variable to choose locale
pref("intl.locale.requested", "");

// Disable default browser checking.
pref("browser.shell.checkDefaultBrowser", false);

// Disable openh264.
pref("media.gmp-gmpopenh264.enabled", false);

// Default to classic view for about:newtab
pref("browser.newtabpage.enhanced", false, sticky);

// Disable health report upload
pref("datareporting.healthreport.uploadEnabled", false);

// Default to no suggestions in the urlbar. This still brings a panel asking
// the user whether they want to opt-in on first use.
pref("browser.urlbar.suggest.searches", false);

// set Firefox Default homepage 
pref("browser.startup.homepage", "https://startseite.treuchtlingen.stadt/");

//Custom theming

pref("devtools.theme", "dark");
pref("extensions.activeThemeID", "tr-light@treuchtlingen.de");

// PREF: process count
// Having more content processes can improve performance when using multiple tabs but
// it will also use more memory. You can reduce the number of content processes if your
// computer is running out of memory. If your computer's system information shows more
// than 8 GB of RAM, you would likely benefit from a high content process limit.
// [1] https://support.mozilla.org/en-US/kb/performance-settings
// default = 8. -1 allows Firefox to use as many as it wants
// user_pref("dom.ipc.processCount", 4);

// set Proxy settings

// Proxy Pac
//pref("network.proxy.type", 2);
//pref("network.proxy.autoconfig_url", "file:///etc/treuchtlingen/proxy.pac");
//pref("signon.autologin.proxy", true);

// Use firefox settings to configure proxy
pref("network.proxy.ftp", "proxy.dmz.treuchtlingen.stadt");
pref("network.proxy.ftp_port", 3128);
pref("network.proxy.http", "proxy.dmz.treuchtlingen.stadt");
pref("network.proxy.http_port", 3128);
pref("network.proxy.share_proxy_settings", true);
pref("network.proxy.socks", "proxy.dmz.treuchtlingen.stadt");
pref("network.proxy.socks_port", 3128);
pref("network.proxy.ssl", "proxy.dmz.treuchtlingen.stadt");
pref("network.proxy.ssl_port", 3128);
pref("network.proxy.type", 1);

pref("network.proxy.no_proxies_on", ".stadt, 192.168.0.0/16, up, 157.40.1.0/24, gis-auskunft.treuchtlingen.eu");
pref("media.peerconnection.ice.proxy_only_if_behind_proxy", true);

pref("signon.management.page.fileImport.enabled", true);

pref("browser.fixup.domainsuffixwhitelist.stadt", true);

//Legacy Applications :(
pref("security.tls.version.enable-deprecated", true);
