#!/bin/bash

SRCDIR="$1"
DESTDIR="$2"

mkdir -p "$DESTDIR"

function map() {
	if [ -d "$SRCDIR/$1" ] && [ -n "$(ls "$SRCDIR/$1")" ]; then
		mkdir -p "$DESTDIR/$2"
		cp -a "$SRCDIR/$1/"* "$DESTDIR/$2/"
	fi
}

function compile_sqlite() {
	if [ -r "$SRCDIR/$1" ] ; then
		mkdir -p "$(printf "$DESTDIR/$2" | sed "s|[^/]*$||")"
		cat "$SRCDIR/$1" | sqlite3 "$DESTDIR/$2"
	fi
}

map global "etc/xdg"
map skel-config "etc/skel/.config"
map skel-local "etc/skel/.local"
compile_sqlite kactivitymanagerd.sql "etc/skel/.local/share/kactivitymanagerd/resources/database"


