# Firefox-ESR Orchestration
## Files
````
├── etc
│   ├── firefox-esr
│   │   └── firefox.js
│   └── skel
│       └── .mozilla
│           └── firefox
│               ├── firefox.default
│               │   ├── containers.json
│               │   ├── SiteSecurityServiceState.txt
│               │   └── user.js
│               └── profiles.ini
└── usr
    └── lib
        └── firefox-esr
            └── distribution
                └── policies.json
````

The policies.json is based on the one from (librewolf)(https://librewolf.net/).

---

# Old information

## Project Information
* [Support Page](https://support.mozilla.org/de/)
* [Planet Mozilla](https://planet.mozilla.org/)
* [Mozilla Developer](https://developer.mozilla.org/de/)
* [Firefox ESR](https://www.mozilla.org/en-US/firefox/enterprise/)

Next Release:
Firefox 91.3 
2021-11-02
* [Firefox Roadmap](https://wiki.mozilla.org/Release_Management/Calendar)

## Firefox Customization Technik
### WhatYouClickWillBeYourConfig
* [Firefox Profilemaker](https://ffprofile.com/#start)

### policy-templates
Projekt um Firefox über Gruppenrichtlinien und zentrale Konfigurationsdateien anzupassen
* [ mozilla / policy-templates](https://github.com/mozilla/policy-templates/blob/master/README.md)

### user.js
* [Privacy-Handbuch](https://privacy-handbuch.de/handbuch_21u.htm)
* [pyllyukko / user.js](https://github.com/pyllyukko/user.js#installation)
* [intika / Librefox](https://github.com/intika/Librefox/)

### AutoConfig
* [Customizing Firefox Using AutoConfig](https://support.mozilla.org/en-US/kb/customizing-firefox-using-autoconfig)

## Test - Setup:
### get Test Setup:
1. Generate Firefox X2Go Profile:
cd .mozilla/firefox
create X2Go Profile directory:
```
mkdir ~./mozilla/firefox/Rathaus.X2Go
```

add X2Go Profile to your profiles.ini
```
...
[Profile3]
Name=X2Go
IsRelative=1
Path=Rathaus.X2Go
...
```
2. Get Profile templates
Change into the .mozilla directory:
```
cd ~./mozilla/
```
Get the template files (only needed once):
```
git@git-intern.treuchtlingen.stadt:Stadt_Treuchtlingen/config.firefox-esr.git
````

The structure inside ~./mozilla/config.friefox-esr should now look like this:
````
├── profile.templates
│   ├── containers.json
│   ├── search.json.mozlz4
│   ├── SiteSecurityServiceState.txt
│   └── user.js
├── README.md
└── src
    └── flush_firefox_settings_and_checkout_templates.sh
````

3. Populate the Rathaus.X2Go Profile
Change into the .mozilla directory:
```
cd ~./mozilla/
```

Run the "flush_firefox_settings_and_checkout_templates.sh" script
```
cd ./mozilla/firefox/
```

---

## 🔴 Autoconfig
[mozilla.org on autoconfig](https://support.mozilla.org/de/kb/firefox-mit-autoconfig-anpassen)

User Acceptance Features
- 🔴 Deploy centralized Bookmark Suggestions
- 🔴 Deploy our own Firefox extension (Themes, Configuration-Updates,...)

OS-Integration / Security
- 🔴 pref.general.disable_button.default_browser
- 🔴 security.disable_button.openDeviceManager
- 🔴 pref.privacy.disable_button.view_passwords
- 🔴 pref.downloads.disable_button.edit_actions 

## 🔴 Firefox-ESR Global Configuration Values (/etc/firefox-esr/firefox.js)

Proxy Pac
- 🟢 lockPref("network.proxy.type", 2);
- 🟢 lockPref("network.proxy.autoconfig_url", "file:///etc/treuchtlingen/proxy.pac");
- 🟢 lockPref("signon.autologin.proxy", true);
- 🟢 lockPref("network.proxy.no_proxies_on;localhost, 127.0.0.1, 192.168.0.0");

disable crash reports
- 🟢 lockPref("breakpad.reportURL", "");
- 🟢 lockPref("browser.tabs.crashReporting.sendReport", false);
- 🟢 lockPref("browser.crashReports.unsubmittedCheck.autoSubmit2", false);

## Performance Settings

- 🟢 lockPref("dom.ipc.processCount",0);
- 🟢 lockPref("dom.ipc.processCount.web",0);
- 🟢 lockPref("accessibility.force_disabled",0);

Disable Smooth Scrolling
- 🟢 lockPref("general.smoothScroll", false);

Disable WebGL Scrolling
- 🟢 lockPref("webgl.disabled", false);

Disable Hardware Rendering
- 🟡 lockPref("gfx.xrender.enabled", true); //dosen't work on debian 🔴 buster 

## Security Settings

disable "Pocket" (third party "save for later" service) & remove urls for good measure
- 🟢 lockPref("browser.pocket.enabled", false);
- 🟢 lockPref("extensions.pocket.enabled", false);
- 🟢 lockPref("browser.pocket.api", "");
- 🟢 lockPref("browser.pocket.site", "");
- 🟢 lockPref("browser.pocket.oAuthConsumerKey", "");

deny cloud upload of screenshots
- 🟢 lockPref("extensions.screenshots.upload-disabled", true);

Hide "Know your Rights"
- 🟢 lockPref("browser.rights.3.shown", true);

Hide "What is New"
- 🟢 lockPref("browser.startup.homepage_override.mstone","ignore");

Switch off Video Autoplay
- 🟢 lockPref("media.autoplay.enabled","false");

Switch off PDFJS
- 🟢 lockPref("pdfjs.disabled", true);

Soft Settings
- 🟢 lockPref("network.trr.mode, 5");

## 🔴 Firefox-ESR *SUGGESTED* Configuration Values (~./mozilla/profilename/user.js)

`0=blank, 1=home, 2=last visited page, 3=resume previous session`
- 🟢 `user_pref("browser.startup.page",  1);`
- 🟢 `user_pref("browser.startup.homepage", "start.duckduckgo.com");`

disable activity and telemetry on new tab pages
- 🟢 `user_pref("browser.newtabpage.enabled", false);`
- 🟢 `user_pref("browser.newtab.preload", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.feeds.telemetry", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.telemetry", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.feeds.snippets", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.section.topstories", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.section.highlights.includePocket", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.showSponsored", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.feeds.discoverystreamfeed", false);`
- 🔴 `user_pref("browser.newtabpage.activity-stream.showSponsoredTopSites", false);`
- 🟢 `user_pref("browser.newtabpage.activity-stream.default.sites", "");`

set language for displaying web pages:
- 🟢 `user_pref("intl.accept_languages", "de-DE, de");`

disable auto-installing Firefox updates
- // `user_pref("app.update.background.scheduling.enabled", false);`
- 🟢 `user_pref("app.update.auto", false);`

disable addons recommendations (use Google Analytics)
- 🟢 `user_pref("extensions.getAddons.showPane", false); //Hidden pref`
- 🟢 `user_pref("extensions.htmlaboutaddons.recommendations.enabled", false);`

disable telemetry
- 🟢 `user_pref("datareporting.policy.dataSubmissionEnabled", false);`
- 🟢 `user_pref("datareporting.healthreport.uploadEnabled", false);`
- 🟢 `user_pref("toolkit.telemetry.enabled", false); //as default`
- 🟢 `user_pref("toolkit.telemetry.unified", false);`
- 🟢 `user_pref("toolkit.telemetry.server", "data:,");`
- 🟢 `user_pref("toolkit.telemetry.archive.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.newProfilePing.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.shutdownPingSender.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.updatePing.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.bhrPing.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.firstShutdownPing.enabled", false);`
- 🟢 `user_pref("toolkit.telemetry.coverage.opt-out", true); //Hidden pref`
- 🟢 `user_pref("toolkit.coverage.opt-out", true); //Hidden pref`
- 🟢 `user_pref("toolkit.coverage.endpoint.base.", "");`
- 🟢 `user_pref("browser.ping-centre.telemetry", false);`

disable sending additional analytics to web servers
- 🟢 `user_pref("beacon.enabled", false);`

disable studies
- 🟢 `user_pref("app.shield.optoutstudies.enabled", false);`

disable normandy/shield
- 🟢 `user_pref("app.normandy.enabled", false);`
- 🟢 `user_pref("app.normandy.api_url", "");`

disable location bar contextual suggestions:
- 🟢 `user_pref("browser.urlbar.suggest.quicksuggest", false);`
- 🟢 `user_pref("browser.urlbar.suggest.quicksuggest.sponsored", false);`

disable WebRTC
- `user_pref("media.peerconnection.enabled", false);`

limit WebRTC IP leaks if using it
- 🟢 `user_pref("media.peerconnection.ice.default_address_only", true);`
- 🟢 `user_pref("media.peerconnection.ice.no_host", true);`
- 🟢 `user_pref("media.peerconnection.ice.proxy_only_if_behind_proxy", true);`

## 🔴 Settings to be discussed

```
user_pref("privacy.sanitize.sanitizeOnShutdown", true);
user_pref("privacy.clearOnShutdown.cache", true);
user_pref("privacy.clearOnShutdown.cookies", true);
user_pref("privacy.clearOnShutdown.downloads", true);
user_pref("privacy.clearOnShutdown.formdata", true);
user_pref("privacy.clearOnShutdown.history", true);
user_pref("privacy.clearOnShutdown.offlineApps", true);
user_pref("privacy.clearOnShutdown.sessions", true);
user_pref("privacy.clearOnShutdown.sitesettings", true);
user_pref("privacy.sanitize.timeSpan", 0);
user_pref("privacy.resistFingerprinting", true);
user_pref("privacy.resistFingerprinting.block_mozAddonManager", true); //Hidden pref
user_pref("privacy.resistFingerprinting.letterboxing", true); //Hidden pref
```
