// This is the Debian specific preferences file for Mozilla Thunderbird
// You can make any change in here, it is the purpose of this file.
// You can, with this file and all files present in the directory
//
//      /etc/thunderbird/pref directory
//
// override any preference that is present in the directory
//
//      /usr/lib/thunderbird/defaults/pref
//
// While your changes will be kept on upgrade if you modify files in
// /etc/thunderbird/pref, please note that they won't be kept if you
// do them in /usr/lib/thunderbird/defaults/pref.

pref("extensions.update.enabled", true);

// Use LANG environment variable to choose locale from system
// The old environment setting 'pref("intl.locale.matchOS", true);' is
// currently not working anymore. The new introduced setting
// 'intl.locale.requested' is now used for this. Setting an empty string is
// pulling the system locale into Thunderbird.
pref("intl.locale.requested", "");

// Disable default mail checking (gnome).
pref("mail.shell.checkDefaultMail", false);

// Disable default mail client check
pref("mail.shell.checkDefaultClient", false);

// if you are not using gnome
pref("network.protocol-handler.app.http", "x-www-browser");
pref("network.protocol-handler.app.https", "x-www-browser");

// This setting is a workaround for some crashes inside the JS engine.
// By this Thunderbird will use more memory and acting slower as the sharing
// memory between interacting JS files is disabled.
pref ("javascript.options.baselinejit", false);

// Uncomment the follwing setting if you want to have a extra mail header field
// for X-Debbugs-Cc, only needed in case you have to work with the Debian
// Bug Tracking System more deeply
//pref("mail.compose.other.header", "X-Debbugs-Cc");

///////////////////////////////////////////////

// Changes @ Stadt Treuchtlingen

// Performance Settings

// Disable Smooth Scrolling
lock_pref("general.smoothScroll", false);

// Disable WebGL Scrolling
lock_pref("webgl.disabled", false);

// Disable Hardware Rendering
lock_pref("gfx.xrender.enabled", true);
lock_pref("gfx.webrender.multithreading", false);

// Environment Settings

// Proxy Setting have been moved to policies.json

// Security Settings
lock_pref("network.cookie.cookieBehavior", 2);
lock_pref("network.cookie.prefsMigrated", true);
lock_pref("network.predictor.cleaned-up", true);
lock_pref("privacy.donottrackheader.enabled", true);

// Offline Sync
lock_pref("offline.autoDetect", false);
lock_pref("offline.startup_state", 0);
lock_pref("places.history.enabled", false);
lock_pref("places.history.expiration.transient_current_max_pages", 67347);


// Soft Settings

// LDAP
lock_pref("ldap_2.autoComplete.directoryServer", "ldap_2.servers.ldapmaster");
lock_pref("ldap_2.autoComplete.useDirectory", true);
lock_pref("ldap_2.servers.ldapmaster.auth.dn", "");
lock_pref("ldap_2.servers.ldapmaster.auth.saslmech", "");
lock_pref("ldap_2.servers.ldapmaster.description", "Gemeinsames Adressbuch");
lock_pref("ldap_2.servers.ldapmaster.filename", "ldap.mab");
lock_pref("ldap_2.servers.ldapmaster.maxHits", 300);
lock_pref("ldap_2.servers.ldapmaster.uri", "ldaps://ldap-adressbuch.treuchtlingen.stadt/dc=ldap-adressbuch,dc=treuchtlingen,dc=stadt??sub?(objectclass=*)");

// Encryption
lock_pref("mail.e2ee.auto_enable", true);

// Mailclient  Startpage
lock_pref("mailnews.start_page.url", "https://startseite.treuchtlingen.stadt/mail");

// Enable some html
lock_pref("mailnews.display.html_as", 3);
// Some people send broken plaintext …
lock_pref("mailnews.display.prefer_plaintext", false);

// Mailclients Shared Tags
lock_pref("mailnews.tags.$label1.color", "#FF0000");
lock_pref("mailnews.tags.$label1.tag", "Wichtig");
lock_pref("mailnews.tags.$label2.color", "#FF9900");
lock_pref("mailnews.tags.$label2.tag", "Dienstlich");
lock_pref("mailnews.tags.$label3.tag", "Persönlich");
lock_pref("mailnews.tags.$label4.color", "#3333FF");
lock_pref("mailnews.tags.$label4.tag", "Zu erledigen");
lock_pref("mailnews.tags.$label5.color", "#993399");
lock_pref("mailnews.tags.$label5.tag", "Später");
lock_pref("mailnews.tags.angebot.color", "#FF9966");
lock_pref("mailnews.tags.angebot.tag", "Angebot");
lock_pref("mailnews.tags.freistaat_bayern.color", "#33FFFF");
lock_pref("mailnews.tags.freistaat_bayern.tag", "Freistaat Bayern");
lock_pref("mailnews.tags.landkreis_wug.color", "#CC0000");
lock_pref("mailnews.tags.landkreis_wug.tag", "Landkreis WUG");
lock_pref("mailnews.tags.mahnung.color", "#993300");
lock_pref("mailnews.tags.mahnung.tag", "Mahnung");
lock_pref("mailnews.tags.rechnung.color", "#FF9900");
lock_pref("mailnews.tags.rechnung.tag", "Rechnung");
lock_pref("mailnews.tags.stadtd21_treuchtlingen.color", "#33CC00");
lock_pref("mailnews.tags.stadt_treuchtlingen.tag", "Stadt Treuchtlingen");
lock_pref("mailnews.tags.termin.color", "#6633FF");
lock_pref("mailnews.tags.termin.tag", "Termin");
lock_pref("mailnews.tags.in_bearbeitung.color", "#0E9D10");
lock_pref("mailnews.tags.in_bearbeitung.tag", "In Bearbeitung");
lock_pref("mailnews.tags.version", 2);

// Mail Purge Question
lock_pref("mail.purge.ask", false);

// Disable Thunderbird Password Vault
lock_pref("pref.privacy.disable_button.view_passwords", false);

// Set Language 
user_pref("intl.locale.requested", "de,en-US");

// Set Print Dialog
user_pref("print.tab_modal.enabled", true);

user_pref("pdfjs.disabled", true); // [DEFAULT: false]
user_pref("pdfjs.enableScripting", false); // [FF86+]

pref("spellchecker.dictionary", "de-DE");
pref("xpinstall.signatures.required", true);
