#!/bin/sh

[ -n "$1" ] && cd "$1"

#Takes file as first argument
get_icon_dir_for_file() {
	CATEGORY="$( printf "%s" "$1" | grep -Po "/.*\K/.*(?=/.*)" )"
	[ -z "$CATEGORY" ] && CATEGORY=apps
	if [ "$(file --mime-type "$1")" = "image/png" ] ; then
		RESOLUTION="$(printf "%s" "$1" | grep -Po "\K[0-9]*x[0-9]*@?[0-9]*(?=/.*)")"
		[ -z "$RESOLUTION" ] && RESOLUTION="scaleable" # Just put it in scaleable, lintian will throw a warning
		printf "$RESOLUTION$CATEGORY"
	elif printf "%s" "$1" | grep -q "symbolic/.*\.svg" ; then
		printf "symbolic$CATEGORY"
	else
		printf "scaleable$CATEGORY"
	fi
}

find -maxdepth 1 \( -name 'treuchtlingen-foxde-*' -or -name 'foxde-*' \) -printf '%f\n' | while read pkg ; do
	ls "$pkg" | while read component ; do
		DEST_DIR=""
		case "$component" in
			applications)
				DEST_DIR="/usr/share/applications/" ;;
			icons)
				DEST_DIR="/usr/share/icons/hicolor/" ;;
			desktop-directories)
				DEST_DIR="/usr/share/desktop-directories/" ;;
			menus)
				DEST_DIR="/etc/xdg/menus/applications-merged/" ;;
		esac
		if [ -n "$DEST_DIR" ] ; then
			mkdir -p "debian/$pkg$DEST_DIR"
			case "$component" in
				icons)
					find "$pkg/$component" -type f -printf "%P\n" | while read f ; do
						DEST_DIR="debian/$pkg$DEST_DIR/$(get_icon_dir_for_file "$f")"
						mkdir -p "$DEST_DIR" 
						cp -ra "$pkg/$component/$f" "$DEST_DIR/$(basename "$f")"
					done ;;
				*)
					for f in $(ls "$pkg/$component") ; do
						cp -ra "$pkg/$component/$f" "debian/$pkg/$DEST_DIR/"
					done ;;
			esac
		fi
	done
done
