#!/bin/sh

[ -n "$1" ] && cd "$1"

#Takes file as first argument
get_icon_dir_for_file() {
	printf "%s\n" "$1" | sed 's|/[^/]*$||' | rev | tr '/' '\n' | while read ps ; do
		ps="$( printf "%s\n" "$ps" | rev )"
		r="$(printf "%s\n" "$ps" | grep -Po "\K[0-9]*x[0-9]*@?[0-9]*" )"
		if [ -n "$r" ]; then
			printf "resolution %s\n" "$r"
		elif [ "$ps" = "symbolic" ] ; then
			printf "resolution symbolic\n"
		elif [ "$ps" = "icons" ] ; then
			break # We exit the loop if we hit the icons directory
		else
			printf "category %s\n" "$ps"
		fi
	done | awk 'BEGIN{ resolution="scaleable"; category="apps"} /^resolution/{ resolution = $2 } /^category/{ category = $2 } END{ print resolution "/" category}'

}

find -maxdepth 1 \( -name 'treuchtlingen-foxde-*' -or -name 'foxde-*' \) -printf '%f\n' | while read pkg ; do
	ls "$pkg" | while read component ; do
		DEST_DIR=""
		case "$component" in
			applications)
				DEST_DIR="/usr/share/applications/" ;;
			icons)
				DEST_DIR="/usr/share/icons/hicolor/" ;;
			desktop-directories)
				DEST_DIR="/usr/share/desktop-directories/" ;;
			menus)
				DEST_DIR="/etc/xdg/menus/applications-merged/" ;;
			bin)
				DEST_DIR="/usr/bin/"
		esac
		if [ -n "$DEST_DIR" ] ; then
			mkdir -p "debian/$pkg$DEST_DIR"
			case "$component" in
				icons)
					find "$pkg/$component" -type f -printf "%P\n" | while read f ; do
						ICON_DEST="debian/$pkg$DEST_DIR/$(get_icon_dir_for_file "$pkg/$component/$f")"
						mkdir -p "$ICON_DEST" 
						cp -ra "$pkg/$component/$f" "$ICON_DEST/$(basename "$f")"
					done ;;
				*)
					for f in $(ls "$pkg/$component") ; do
						cp -ra "$pkg/$component/$f" "debian/$pkg/$DEST_DIR/"
					done ;;
			esac
		fi
	done
done
