#!/bin/bash

PERSONAL_DATA_FILE="$HOME/.config/treuchtlingen-personal-data"
if [[ "$1" == "--initial-setup" ]] ; then
	if [[ -f "$PERSONAL_DATA_FILE" ]] ; then
		exit
	fi
fi

konsole -e treuchtlingen-personal-data-entry.lua --data-file "$PERSONAL_DATA_FILE" --import-fallback-command "treuchtlingen-personal-data-libreoffice.lua" --savehooks "sleep 2" "treuchtlingen-personal-data-libreoffice.lua --data-file '$PERSONAL_DATA_FILE' --to-libreoffice" "treuchtlingen-personal-data-thunderbird.lua --data-file '$PERSONAL_DATA_FILE'" "treuchtlingen-personal-data-mail-signature.lua --data-file '$PERSONAL_DATA_FILE' --to-signature-file '/vorlagen/e-mail-signaturen/$USER.autogen.txt'" '[ ! -f "/vorlagen/e-mail-signaturen/$USER.txt" ] && cp "/vorlagen/e-mail-signaturen/$USER.autogen.txt" "/vorlagen/e-mail-signaturen/$USER.txt"'
