#!/bin/bash

if [ -z "$1" -o "$1" == "-h" -o "$1" == "--help" ]; then
	echo "Usage: $0 PATH[:FILESYSTEM] [...]"
	exit 1
fi

while [ -n "$1" ]; do
	DIR=$(echo "$1" | cut -d: -f 1)
	FS=$(echo "$1" | cut -d: -f 2)
	if [ "${DIR}" == "${FS}" ]; then
		FS=""
	fi

	grep -q " ${DIR} " /proc/mounts
	if [ $? -eq 0 ]; then
		if [ -n "$FS" ]; then
			grep " ${DIR} " /proc/mounts | grep -q " ${FS} "
			if [ $? -eq 0 ]; then
				R_OK="${R_OK} ${DIR}(${FS})"
			else
				R_WRONGFS="${R_WRONGFS} ${DIR}(not ${FS})"
			fi
		else
			R_OK="${R_OK} ${DIR}(-)"
		fi
	else
		R_NOTMOUNTED="${R_NOTMOUNTED} $DIR"
	fi

	shift
done

# Return-Code
if [ -n "${R_NOTMOUNTED}" ]; then
	RETMSG="CRITICAL"
	RETCODE=2
elif [ -n "${R_WRONGFS}" ]; then
	RETMSG="WARNING"
	RETCODE=1
else
	RETMSG="OK"
	RETCODE=0
fi

# Output
OUT=""
if [ -n "${R_NOTMOUNTED}" ]; then
	OUT="not mounted:${R_NOTMOUNTED}"
fi
if [ -n "${R_WRONGFS}" ]; then
	OUT="${OUT}${OUT:+ - }wrong fs:${R_WRONGFS}"
fi
if [ -n "${R_OK}" ]; then
	OUT="${OUT}${OUT:+ - }looks fine:${R_OK}"
fi

# Quit the script
echo "Mounts ${RETMSG}: ${OUT}"
exit $RETCODE

