#!/usr/bin/env python

import os
import re
import shlex
import subprocess
import sys

allowed = [
		r'^/usr/lib/nagios/plugins/check_',
		r'^/usr/lib/treuchtlingen/plugins/check_',
		r'^/usr/lib/treuchtlingen/plugins/obsolete/check_',
		r'^/usr/local/plugins/check_',
		r'^/usr/local/plugins/obsolete/check_',
		r'^/usr/local/monitoringplugins/check_',
		r'^/usr/bin/lsb_release\s+-d$',
		# r'^sudo\s+/usr/lib/nagios/plugins/check_',
		# r'^sudo\s+/usr/lib/treuchtlingen/plugins/check_',
	]

cmdline = os.getenv('SSH_ORIGINAL_COMMAND')
if not cmdline:
	print 'This is just a wrapper, no command specified!'
	sys.exit(3)

for maybe in allowed:
	if re.match(maybe, cmdline):
		cmdline = shlex.split(cmdline)

		try:
			cmd = subprocess.Popen(cmdline, stdout=subprocess.PIPE)
		except Exception, exc:
			print 'Could not execute plugin ("%s"): %s' % (' '.join(cmdline), exc)
			sys.exit(3)
		else:
			print cmd.communicate()[0].rstrip()
			sys.exit(cmd.returncode)

print '%s: No allowed command found!' % sys.argv[0]
sys.exit(3)

