#!/bin/bash

PATH=/bin:/sbin:/usr/bin:/usr/sbin
IPTS=$(which iptables-save)

RULESFILE=/etc/iptables.saved
COMMAND="iptables-save | grep -v '^#' | sed 's/[\[0-9:\]\+]/[]/'"
# FIXME: --ignore-fail2ban
COMMAND="iptables-save | grep -v '^#' | grep -v "fail2ban" | sed 's/[\[0-9:\]\+]/[]/'"
TMPFILE=`mktemp /tmp/check_iptables.XXXXXXXX`

### Help

if [ "$1" == "-h" -o "$1" == "--help" ]; then
	echo -e "$(basename $0): Check saved iptables set vs. actuel\n"
	echo -e "Usage: $(basename $0) [-h|--help] [--write-rules-file] [--dump-rules]\n"
	echo -e "Options:"
	echo -e "--write-rules-file\t\twrites actuel IPTables rule set to \"${RULESFILE}\""
	echo -e "--dump-rules\t\tshows (but does NOT write) actuel rule set"
	echo -e "\n"
	exit 0
fi

### Do something different (no plugin call)

if [ -n "$1" ]; then
	if [ "$UID" != "0" ]; then
		echo -e "$(basename $0): Sorry, need root"
		exit 3
	fi

	if [ "$1" == "--dump-rules" ]; then
		eval ${COMMAND}
		exit 0
	elif [ "$1" == "--write-rules-file" ]; then
		eval ${COMMAND} > ${RULESFILE}
		exit 0
	fi
fi

### Look for basefile

if [ ! -r "${RULESFILE}" ]; then
	echo -e "Could not read base file \"${RULESFILE}\", please create with following command:\n"
	echo -e "$0 --write-rules-file\n"
	exit 3
fi


### Create tmpfile

if [ -z "$TMPFILE" ]; then
	echo "Could not create tmpfile"
	exit 3
fi



### Get current iptables rules

eval "sudo $COMMAND" > $TMPFILE

diff -u $RULESFILE $TMPFILE >/dev/null



### See if both files ${DIFF}er

if [ $? -eq 0 ]; then
	echo "OK - current iptables rules match saved ones"
	RETCODE=0
elif [ $? -eq 1 ]; then
	echo "CRITICAL - current iptables rules DON'T match saved ones"
	diff -u $RULESFILE $TMPFILE
	RETCODE=2
else
	echo "UNKNOWN - Something strange happened..."
	diff -u $RULESFILE $TMPFILE
	RETCODE=3
fi

rm -f $TMPFILE
exit ${RETCODE:-3}

