#!/usr/bin/python

import argparse
import re
import socket
import sys
import telnetlib

##############################################################################

parser = argparse.ArgumentParser(description='Plugin to check OpenVPN connections via management interface')

parser.add_argument('-H', '--host', dest='host', default='localhost', help='Host/IP to connect to')
parser.add_argument('-p', '--port', dest='port', type=int, default=0, help='Port to connect to')
parser.add_argument('-P', '--password', dest='password', default='', help='Password for management interface')
parser.add_argument('-t', '--timeout', dest='timeout', type=int, default=3, help='Timeout for answering commands')
parser.add_argument('--prompt-password', dest='prompt_password', default='PASSWORD:')
parser.add_argument('--prompt-success', dest='prompt_success', default='SUCCESS:')
parser.add_argument('-v', dest='verb', action='count', default=0, help='Be verbose')

args = parser.parse_args()

##############################################################################

if not args.port:
	print 'OPENVPN Unknown - Need a port number!'
	sys.exit(3)

##############################################################################

def read(tn):
	out = ''
	got = tn.read_eager()
	while got:
		out = out + got
		got = tn.read_eager()

	return out

def log(level, msg):
        if args.verb >= level:
		print(u'V%s: %s' % (level, msg) )


##############################################################################

try:
    tn = telnetlib.Telnet(args.host, args.port)
except socket.error, e:
    print('OPENVPN CRITICAL - %s' % e)
    sys.exit(2)
log(1, 'Connected')

log(2, 'Wait for %s' % args.prompt_password)
data = tn.read_until(args.prompt_password, args.timeout)
log(3, 'Data: >>>>>%s<<<<<' % data)

if args.password:
	log(2, 'Send password...')
	tn.write('%s\n' % args.password)
else:
	log(2, 'No password given')
    
data = tn.read_until('SUCCESS:', args.timeout)
log(3, 'Data: >>>>>%s<<<<<' % data)

if 'PASSWORD:' in data:
	print('OPENVPN Unknown - Wrong password!')
	sys.exit(3)

data = read(tn)
log(3, 'Dummy data: >>>>>%s<<<<<' % data)

tn.write('status\n')
data_status = tn.read_until('\r\nEND\r\n', args.timeout)
log(3, 'Status data: >>>>>%r<<<<<' % data_status)

tn.write('load-stats\n')
data_stats = tn.read_until('\r\n', args.timeout)
log(3, 'Stats data: >>>>>%r<<<<<' % data_stats)

try:
	clients = long(re.search('nclients=(\d+)', data_stats).groups()[0])
except IndexError:
	print('OPENVPN Unknown - Uh... no "nclients" found in "%r"' % data_stats)
	sys.exit(3)

print(u'OPENVPN OK - %s client connection(s)|clients=%s;;;;' % (clients, clients,) )
sys.exit(0)

