# XRDialog

XRDialog is a minimal, temporary tool designed to help users organize incoming invoices by creating structured directories with metadata. It serves as a predecessor to the full xrflow application.

---

## Features

- Simple form-based dialog for collecting invoice metadata
- Structured folder creation

---

## Configuration

XRDialog requires a configuration file at: `~/.config/xrdialog/config`

### Configuration Format

```ini
[Paths]
Incomming_Invoices=/aktenplan/.0/.04/.042/.0420/Eingangsrechnungen
Invoices=/aktenplan/.9/.95/.952/9522-Rechnungen
Invoice_Archive=/aktenplan/.9/.95/.952/9523-Rechnungs-Archiv

[Security]
PIN=8830
```
**Note:** must be absolute paths (no tilde expansion).

### Configuration Keys

- `Incomming_Invoices`: Directory where new invoice files are stored
- `Invoices`: Target directory where organized invoice folders will be created
- `Invoice_Archive`: Archive directory (for future use)

### Haushaltsstellen (sry for german)

**File:** `~/.config/xrdialog/haushaltsstellen.csv`

---

## Usage

### Run

```bash
xrdialog
```

### Command-Line Mode

```bash
xrdialog --invoice /path/to/invoice.pdf
```

### "Open With..." !FIXME! Integration (KDE)

- **PDF files** (`application/pdf`)
- **XML files** (`application/xml`, `text/xml`)
- **Image files** (`image/png`, `image/jpeg`)

## Folder

**Example:**
```
2026-01-12_12345_BertBeispiel_87654321_susi_controlled:y_project-a/
└── invoice.pdf
```

---

## Building

### Dependencies

```bash
sudo apt install \
    build-essential \
    cmake \
    pkg-config \
    extra-cmake-modules \
    qt6-tools-dev \
    qt6-base-dev \
    qt6-declarative-dev \
    linguist-qt6 \
    libkf6i18n-dev \
    kirigami2-dev
```

### Build Steps

```bash
cd /usr/local/src/kirigami/xrdialog
mkdir build && cd build
cmake ..
make
```

### Building the Debian Package

```bash
cd /usr/local/src/kirigami/xrdialog
dpkg-buildpackage -us -uc -b
```

---

## License

XRDialog is licensed under the **GNU Affero General Public License v3.0 only (AGPL-3.0-only)**.

See [LICENSE](LICENSE) for the full license text.
