#ifndef WORKFLOWLOGGER_H
#define WORKFLOWLOGGER_H

#include <QObject>
#include <QString>
#include <QStringList>

class WorkflowLogger : public QObject
{
    Q_OBJECT

public:
    explicit WorkflowLogger(QObject *parent = nullptr);

    void setLogPath(const QString &folderPath);
    void logFolderCreated(const QString &folderPath);
    void logFileMoved(const QString &sourcePath, const QString &targetPath);
    void logChecksumCreated(const QString &filePath, const QString &checksum);
    void logStampedPdfCreated(const QString &filePath);
    void logPinValidated(const QString &user);
    void logReviewedStatus(bool reviewed, const QString &user);
    void logBudgetCode(const QString &budgetCode);
    void logError(const QString &operation, const QString &message);
    void logMetadataUpdated(const QString &user);
    void writeLog();
    void appendToLog(const QString &folderPath, const QString &user);

private:
    QString logPath;
    QStringList logEntries;
    QString timestamp();
};

#endif // WORKFLOWLOGGER_H
