# XRDialog

![XRDialog - Invoicehelper](https://git-intern.treuchtlingen.stadt/Stadt_Treuchtlingen/xrdialog/media/branch/main/doc/screenshots/xrdialog.gif "Invoicehelper i usage")


XRDialog is a minimal, temporary tool designed to help users organize incoming invoices by creating structured directories with metadata. It serves as a predecessor to the full xrflow application.

---

## Features

- Simple form-based dialog for collecting invoice metadata
- Structured folder creation

---

## Configuration

XRDialog requires a configuration files at: `~/.config/xrdialog/config/xrdialog`

### Configuration Format

`config`
```ini
[Paths]
incoming_invoices=/aktenplan/.0/.04/.042/.0420/Eingangsrechnungen/
invoices=/aktenplan/.9/.95/.952/9522-Rechnungen/
invoice_archive=/aktenplan/.9/.95/.952/9523-Rechnungs-Archiv

[Stamp]
font=DejaVuSans-Bold
font_size=12
color=#FF0000
x=220
y=810
rotation=-15
prefix=Eingang:
page_width=595
page_height=842

[OCR]
language=deu

[Folder]
icon_checked_yes=folder-green
icon_checked_no=folder-red
icon_checked_undefined=folder-yellow

[Help]
help_url=https://git-intern.treuchtlingen.stadt/Stadt_Treuchtlingen/xrdialog/src/branch/main/doc/help/help_de.md

[BudgetCode]
budget_code_path=~/.config/xrdialog/haushaltsstellen.csv

[Behavior]
open_folder_after_create=true
close_after_create=true
```

`secret`
```ini
[Security]
pin_hash=03ac674216f3e15c761ee1a5e255f067953623c8b388b4459e13f978d7c846f4
```

**Note:** must be absolute paths (no tilde expansion).

### Configuration Keys

- `Incomming_Invoices`: Directory where new invoice files are stored
- `Invoices`: Target directory where organized invoice folders will be created
- `Invoice_Archive`: Archive directory (for future use)

### Haushaltsstellen (sry for german)

**File:** `~/.config/xrdialog/haushaltsstellen.csv`

---

## Usage

### Run

```bash
xrdialog
```

### Command-Line Mode

```bash
xrdialog --invoice /path/to/invoice.pdf
```

### "Open With..." !FIXME! Integration (KDE)

- **PDF files** (`application/pdf`)
- **XML files** (`application/xml`, `text/xml`)
- **Image files** (`image/png`, `image/jpeg`)

## Folder

**Example:**
```
2026-01-12_12345_BertBeispiel_87654321_susi_controlled:y_project-a/
└── invoice.pdf
```

---

## Building

### Dependencies

```bash
sudo apt install \
    build-essential \
    cmake \
    pkg-config \
    extra-cmake-modules \
    qt6-tools-dev \
    qt6-base-dev \
    qt6-declarative-dev \
    linguist-qt6 \
    libkf6i18n-dev \
    kirigami2-dev
```

### Runner usage

xrdialog will start a ci pipline to build a debian package.
The used configuration can be found here:

```Path
xrdialog/.forgejo/workflows/build.yml
```

Needed steps:
```Url
https://git-intern.treuchtlingen.stadt/Stadt_Treuchtlingen/tool.debian-buildscripts
```

### Update Version
1. CMakeLists.txt 
2. Changelog (snmogls script!)
3. po-Datei

#### `update_deb_changelog.sh`
1. Update Application and package Version

CMakeLists.txt 
```file
cmake_minimum_required(VERSION 3.16)
project(xrdialog VERSION 0.2.0 LANGUAGES CXX)
...

```

debian/changelog 
```
xrdialog (0.2.0-1) trixie; urgency=medium

  [ Sebastian Mogl ]
  * Added example secret configuration
...
```

2. run `update_deb_changelog.sh`

3. Download artifacts (forgejo actions)

![Debian Package Download](https://git-intern.treuchtlingen.stadt/Stadt_Treuchtlingen/xrdialog/media/branch/main/doc/screenshots/forgejo_artifacts_download.png "forgejo actions - artifacts download")


Download ZIP archive from forgejo actions site.

Unzip Ccontents to `output_debian` folder:
```.directory
output_debian/
├── xrdialog_0.2.0-1_amd64.build
├── xrdialog_0.2.0-1_amd64.buildinfo
├── xrdialog_0.2.0-1_amd64.changes
├── xrdialog_0.2.0-1_amd64.deb
├── xrdialog_0.2.0-1.debian.tar.xz
├── xrdialog_0.2.0-1.dsc
├── xrdialog_0.2.0.orig.tar.gz
└── xrdialog-dbgsym_0.2.0-1_amd64.deb
```

run `upload_deb.sh`
```

```


## Manual Build

### Build Steps

```bash
cd /usr/local/src/kirigami/xrdialog
mkdir build && cd build
cmake ..
make
```

### Building the Debian Package

```bash
cd /usr/local/src/kirigami/xrdialog
dpkg-buildpackage -us -uc -b
```

---

## License

XRDialog is licensed under the **GNU Affero General Public License v3.0 only (AGPL-3.0-only)**.
