#include "checksumgenerator.h"
#include <QFile>
#include <QFileInfo>
#include <QTextStream>
#include <QCryptographicHash>

ChecksumGenerator::ChecksumGenerator(QObject *parent)
    : QObject(parent)
{
}

bool ChecksumGenerator::createChecksumFile(const QString &filePath)
{
    QString checksum = calculateChecksum(filePath);
    if (checksum.isEmpty()) {
        return false;
    }

    QFileInfo fi(filePath);
    QString checksumPath = fi.path() + "/." + fi.fileName() + ".sha256";
    QFile checksumFile(checksumPath);
    if (!checksumFile.open(QIODevice::WriteOnly | QIODevice::Text)) {
        return false;
    }

    QTextStream out(&checksumFile);
    out << checksum << "  " << QFileInfo(filePath).fileName() << "\n";
    checksumFile.close();

    return true;
}

QString ChecksumGenerator::calculateChecksum(const QString &filePath)
{
    QFile file(filePath);
    if (!file.open(QIODevice::ReadOnly)) {
        return QString();
    }

    QCryptographicHash hash(QCryptographicHash::Sha256);
    hash.addData(&file);
    file.close();

    return hash.result().toHex();
}
