#ifndef PDFPROCESSOR_H
#define PDFPROCESSOR_H

#include <QObject>
#include <QString>

class ConfigManager;

class PdfProcessor : public QObject
{
    Q_OBJECT

public:
    explicit PdfProcessor(QObject *parent = nullptr);

    void setConfigManager(ConfigManager *config);

    Q_INVOKABLE bool createStampedCopy(
        const QString &inputPdf,
        const QString &outputFolder,
        const QString &outputName,
        const QString &receiptDate
    );

    Q_INVOKABLE bool isAvailable() const;
    Q_INVOKABLE bool isOcrAvailable() const;

private:
    ConfigManager *configMgr;
    bool createStampPdf(const QString &stampPath, const QString &receiptDate);
    bool applyOcr(const QString &inputPdf, const QString &outputPdf);
};

#endif // PDFPROCESSOR_H
