#ifndef THUMBNAILGENERATOR_H
#define THUMBNAILGENERATOR_H

#include <QObject>
#include <QString>

class ThumbnailGenerator : public QObject
{
    Q_OBJECT

public:
    explicit ThumbnailGenerator(QObject *parent = nullptr);

    Q_INVOKABLE QString createThumbnail(const QString &pdfPath);
    Q_INVOKABLE QString createStampedThumbnail(const QString &stampedPdfPath);
    Q_INVOKABLE bool moveThumbnailsToFolder(const QString &targetFolder);
    Q_INVOKABLE QString getThumbnailPath() const;

private:
    QString generateThumbnail(const QString &pdfPath, const QString &outputPath);
    QString currentThumbnailPath;
    QString currentStampedThumbnailPath;
    QString originalBaseName;
    QString stampedBaseName;
};

#endif // THUMBNAILGENERATOR_H
