#ifndef CONFIGMANAGER_H
#define CONFIGMANAGER_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QMap>

class ConfigManager : public QObject
{
    Q_OBJECT

public:
    explicit ConfigManager(QObject *parent = nullptr);

    Q_INVOKABLE bool loadConfig();
    Q_INVOKABLE QString getPath(const QString &key);
    Q_INVOKABLE bool isConfigured() const;
    Q_INVOKABLE QStringList getBudgetCodes();
    Q_INVOKABLE bool validatePin(const QString &pin) const;
    Q_INVOKABLE QString getConfigErrors() const;
    Q_INVOKABLE bool checkDirectories();

    // Stamp configuration
    QString getStampFont() const;
    int getStampFontSize() const;
    QString getStampColor() const;
    int getStampX() const;
    int getStampY() const;
    int getStampRotation() const;
    QString getStampPrefix() const;
    int getPageWidth() const;
    int getPageHeight() const;
    bool isStampConfigured() const;
    QString getStampConfigErrors() const;

    // OCR configuration
    QString getOcrLanguage() const;
    bool isOcrConfigured() const;

    // Folder icon configuration
    Q_INVOKABLE QString getFolderIconCheckedYes() const;
    Q_INVOKABLE QString getFolderIconCheckedNo() const;
    Q_INVOKABLE QString getFolderIconCheckedUndefined() const;
    Q_INVOKABLE bool isFolderIconsConfigured() const;
    Q_INVOKABLE QString getFolderIconConfigErrors() const;

    // Help configuration
    Q_INVOKABLE QString getHelpUrl() const;

    // Behavior configuration
    Q_INVOKABLE bool openFolderAfterCreate() const;
    Q_INVOKABLE bool closeAfterCreate() const;

private:
    QMap<QString, QString> paths;
    QStringList budgetCodes;
    QString budgetCodePath;
    bool configured;
    QString storedPinHash;
    QString configErrors;

    // Stamp settings
    QString stampFont;
    int stampFontSize;
    QString stampColor;
    int stampX;
    int stampY;
    int stampRotation;
    QString stampPrefix;
    int pageWidth;
    int pageHeight;

    // OCR settings
    QString ocrLanguage;

    // Folder icon settings
    QString folderIconCheckedYes;
    QString folderIconCheckedNo;
    QString folderIconCheckedUndefined;

    // Help settings
    QString helpUrl;

    // Behavior settings
    bool openFolderAfterCreateEnabled;
    bool closeAfterCreateEnabled;

    void loadBudgetCodes();
};

#endif // CONFIGMANAGER_H
