#ifndef INVOICEOPERATIONS_H
#define INVOICEOPERATIONS_H

#include <QObject>
#include <QString>
#include <QVariantMap>
#include "workflowlogger.h"

class InvoiceOperations : public QObject
{
    Q_OBJECT

public:
    explicit InvoiceOperations(QObject *parent = nullptr);

    WorkflowLogger* getWorkflowLogger() { return &workflowLogger; }

    Q_INVOKABLE bool createInvoiceFolder(
        const QString &invoiceFile,
        const QString &targetBasePath,
        const QString &receiptStamp,
        const QString &date,
        const QString &sender,
        const QString &invoiceNumber,
        const QString &budgetCode,
        const QString &user,
        bool reviewed,
        const QString &comment,
        const QString &amount,
        const QString &folderIcon
    );

    Q_INVOKABLE QString getCurrentUser();
    Q_INVOKABLE void openFile(const QString &filePath);
    Q_INVOKABLE void logChecksum(const QString &filePath, const QString &checksum);
    Q_INVOKABLE void logStampedPdf(const QString &filePath);
    Q_INVOKABLE void logPinValidated(const QString &user);
    Q_INVOKABLE void logReviewedStatus(bool reviewed, const QString &user);
    Q_INVOKABLE void logBudgetCode(const QString &budgetCode);
    Q_INVOKABLE void logError(const QString &operation, const QString &message);
    Q_INVOKABLE void finalizeLog();

    Q_INVOKABLE bool folderExists(const QString &targetBasePath, const QString &folderName);
    Q_INVOKABLE bool invoiceNumberExists(const QString &targetBasePath, const QString &invoiceNumber);
    Q_INVOKABLE bool createNoticeFile(const QString &folderPath, const QString &date, const QString &noticeText);
    Q_INVOKABLE QVariantMap loadInvoiceMetadata(const QString &filePath);
    Q_INVOKABLE bool updateInvoiceMetadata(
        const QString &folderPath,
        const QString &receiptStamp,
        const QString &date,
        const QString &sender,
        const QString &invoiceNumber,
        const QString &budgetCode,
        const QString &user,
        bool reviewed,
        const QString &comment,
        const QString &amount,
        const QString &folderIcon
    );
    Q_INVOKABLE QString getNextVersionedFilename(const QString &folderPath, const QString &baseName);

private:
    QString buildFolderName(
        const QString &date,
        const QString &sender,
        const QString &invoiceNumber,
        const QString &budgetCode,
        const QString &user,
        bool reviewed,
        const QString &comment
    );

    void createDirectoryFile(
        const QString &folderPath,
        const QString &receiptStamp,
        const QString &date,
        const QString &sender,
        const QString &invoiceNumber,
        const QString &budgetCode,
        const QString &user,
        bool reviewed,
        const QString &comment,
        const QString &amount,
        const QString &folderIcon
    );

    WorkflowLogger workflowLogger;
};

#endif // INVOICEOPERATIONS_H
