#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include <QUrl>
#include <QCommandLineParser>
#include <QCommandLineOption>
#include <KLocalizedContext>
#include <KLocalizedString>
#include "configmanager.h"
#include "invoiceoperations.h"
#include "pdfprocessor.h"
#include "checksumgenerator.h"
#include "thumbnailgenerator.h"

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);

    // metadata
    QCoreApplication::setApplicationName("XRDialog");
    QCoreApplication::setOrganizationName("KDE");
    QCoreApplication::setOrganizationDomain("kde.org");

    // i18n
    KLocalizedString::setApplicationDomain("xrdialog");

    // commandline arguments
    QCommandLineParser parser;
    parser.setApplicationDescription("XRDialog - Invoice Metadata Dialog");
    parser.addHelpOption();
    parser.addVersionOption();

    QCommandLineOption invoiceOption(QStringList() << "invoice",
                                     "Invoice file to process",
                                     "file");
    parser.addOption(invoiceOption);

    QCommandLineOption configOption(QStringList() << "configfile",
                                    "Path to configuration file",
                                    "configfile");
    parser.addOption(configOption);

    parser.addPositionalArgument("file", "Invoice file to process (optional)");
    parser.process(app);

    QString initialInvoice = parser.value("invoice");
    QString configPath = parser.value("configfile");

    // positional argument
    QStringList positionalArgs = parser.positionalArguments();
    if (initialInvoice.isEmpty() && !positionalArgs.isEmpty()) {
        initialInvoice = positionalArgs.first();
    }

    // QML
    QQmlApplicationEngine engine;

    // C++
    ConfigManager configMgr;
    if (!configPath.isEmpty()) {
        configMgr.setConfigPath(configPath);
    }
    configMgr.loadConfig();

    InvoiceOperations invoiceOps;
    invoiceOps.setConfigManager(&configMgr);
    PdfProcessor pdfProcessor;
    pdfProcessor.setConfigManager(&configMgr);
    ChecksumGenerator checksumGen;
    ThumbnailGenerator thumbGen;

    // C++ objects to QML
    engine.rootContext()->setContextProperty("configMgr", &configMgr);
    engine.rootContext()->setContextProperty("invoiceOps", &invoiceOps);
    engine.rootContext()->setContextProperty("pdfProcessor", &pdfProcessor);
    engine.rootContext()->setContextProperty("checksumGen", &checksumGen);
    engine.rootContext()->setContextProperty("thumbGen", &thumbGen);
    engine.rootContext()->setContextProperty("initialInvoice", initialInvoice);
    engine.rootContext()->setContextProperty("appVersion", QStringLiteral(APP_VERSION));

    // QML i18n
    engine.rootContext()->setContextObject(new KLocalizedContext(&engine));

    // QML file FIXME:REssources!!!
    engine.load(QUrl(QStringLiteral("qrc:/qml/main.qml")));

    // Check QML
    if (engine.rootObjects().isEmpty()) {
        return -1;
    }

    return app.exec();
}
