/*
 * XRechnung Viewer Suite
 *
 * Copyright (C) 2024 Klaas Freitag <opensource@freisturz.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef XRVSETUP_H
#define XRVSETUP_H

#include <QObject>
#include <QDir>
#include <QNetworkAccessManager>
#include <QSettings>

class QNetworkReply;

class XRVSetup : public QObject
{
    Q_OBJECT
public:
    explicit XRVSetup(QObject *parent = nullptr);

    enum class State {
        Undeclared,
        NotExist,
        Available,
        Download,
        Error
    };

    QMap<QString, State> check();
#ifdef WITH_AUTO_DOWNLOAD
    void doDownload(QMap<QString, State> state);
    QFileInfo extractZip(const QString& fileId, const QString& zipFile);
#endif

signals:
    void done(QMap<QString, State>);

#ifdef WITH_AUTO_DOWNLOAD
private slots:
    void downloadProgress(qint64 recieved, qint64 total);
    void downloadFinished(QNetworkReply *data);
#endif

private:
    bool checkFile(const QString& fileId);
#ifdef WITH_AUTO_DOWNLOAD
    void tryDownload(const QString& fileId);
#endif
    bool finalState(const QString& fileId);
    bool validateState();

    QNetworkAccessManager _nam;
    const QByteArray DownloadId{"DownloadId"};
    QDir _saxonDir;
    QSettings _config;
    QMap<QString, State> _stateMap;
};

#endif // XRVSETUP_H
